/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.iiif;

import eu.europeana.iiif.service.ManifestService;
import eu.europeana.iiif.service.ManifestSettings;
import eu.europeana.iiif.web.ManifestController;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.support.SpringBootServletInitializer;
import org.springframework.cloud.client.circuitbreaker.EnableCircuitBreaker;
import org.springframework.cloud.netflix.hystrix.dashboard.EnableHystrixDashboard;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@SpringBootApplication
@EnableHystrixDashboard
@EnableCircuitBreaker
@PropertySource(value={"classpath:build.properties"}, ignoreResourceNotFound=true)
public class IiifApplication
extends SpringBootServletInitializer {
    @Bean
    public WebMvcConfigurer corsConfigurer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public ManifestSettings manifestSettings() {
        return new ManifestSettings();
    }

    @Bean
    public ManifestService manifestService() {
        return new ManifestService(this.manifestSettings());
    }

    @Bean
    public ManifestController manifestController() {
        return new ManifestController(this.manifestService());
    }

    public static void main(String[] args) {
        SpringApplication.run(IiifApplication.class, (String[])args);
    }
}

