/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.migrations.reader;

import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.migrations.model.MigrationJobMetadata;
import eu.europeana.fulltext.migrations.repository.MigrationRepository;
import eu.europeana.fulltext.util.GeneralUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.springframework.batch.item.data.AbstractPaginatedDataItemReader;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class MigrationAnnoPageReader
extends AbstractPaginatedDataItemReader<AnnoPage> {
    private static final Logger logger = LogManager.getLogger(MigrationAnnoPageReader.class);
    protected final int limit;
    protected final MigrationRepository repository;
    protected final MigrationJobMetadata jobMetadata;

    public MigrationAnnoPageReader(int limit, MigrationRepository repository, MigrationJobMetadata jobMetadata) {
        this.repository = repository;
        this.limit = limit;
        this.jobMetadata = jobMetadata;
    }

    protected void doOpen() throws Exception {
        super.doOpen();
        this.setSaveState(false);
        this.setName(this.getClassName());
    }

    @NotNull
    protected Iterator<AnnoPage> doPageRead() {
        List annoPageIds;
        if (logger.isDebugEnabled()) {
            logger.debug("Reading from DB. lastObjectId={}", (Object)this.jobMetadata.getLastAnnoPageId());
        }
        if (!CollectionUtils.isEmpty((Collection)(annoPageIds = this.getAnnoPages(this.limit, this.jobMetadata.getLastAnnoPageId())))) {
            this.jobMetadata.setLastAnnoPageId(((AnnoPage)annoPageIds.get(annoPageIds.size() - 1)).getDbId());
            if (logger.isTraceEnabled()) {
                logger.trace("Fetched {} records. set new lastObjectId={}; fetched records={}", (Object)annoPageIds.size(), (Object)this.jobMetadata.getLastAnnoPageId(), (Object)Arrays.toString(GeneralUtils.getAnnoPageObjectIds((List)annoPageIds)));
            }
            return annoPageIds.iterator();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("No results found during AnnoPage read. lastObjectId={}", (Object)this.jobMetadata.getLastAnnoPageId());
        }
        return Collections.emptyIterator();
    }

    protected String getClassName() {
        return MigrationAnnoPageReader.class.getName();
    }

    protected List<AnnoPage> getAnnoPages(int count, @Nullable ObjectId objectId) {
        return this.repository.getAnnoPages(count, objectId, false);
    }
}

