/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.migrations.reader;

import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.migrations.repository.MigrationRepository;
import eu.europeana.fulltext.util.GeneralUtils;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.batch.item.data.AbstractPaginatedDataItemReader;

public class MigrationAnnoPageModificationReader
extends AbstractPaginatedDataItemReader<AnnoPage> {
    private static final Logger logger = LogManager.getLogger(MigrationAnnoPageModificationReader.class);
    private final MigrationRepository repository;
    private final Date maxModificationDate = Date.from(LocalDate.of(2022, Month.JULY, 1).atStartOfDay(ZoneId.of("UTC+1")).toInstant());
    private final int readerPageSize;

    public MigrationAnnoPageModificationReader(int readerPageSize, MigrationRepository repository) {
        this.repository = repository;
        this.readerPageSize = readerPageSize;
    }

    protected void doOpen() throws Exception {
        super.doOpen();
        this.setSaveState(false);
        this.setPageSize(this.readerPageSize);
        this.setName(MigrationAnnoPageModificationReader.class.getName());
    }

    @NotNull
    protected Iterator<AnnoPage> doPageRead() {
        int skip = this.page * this.pageSize;
        List records = this.repository.getAnnoPagesModifiedBefore(this.maxModificationDate, skip, this.pageSize);
        if (logger.isTraceEnabled()) {
            logger.trace("Fetched {} records. skip={}, pageSize={}, annoPageIds={}", (Object)records.size(), (Object)skip, (Object)this.pageSize, (Object)Arrays.toString(GeneralUtils.getAnnoPageObjectIds((List)records)));
        }
        return records.iterator();
    }
}

