/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.migrations.model;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Id;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.bson.types.ObjectId;

@Entity(value="MigrationJobMetadata", useDiscriminator=false)
public class MigrationJobMetadata {
    @Id
    private ObjectId dbId;
    private final AtomicReference<ObjectId> lastAnnoPageIdRef = new AtomicReference();
    private final AtomicLong processedCount;

    public MigrationJobMetadata(ObjectId lastAnnoPageId, AtomicLong processedCount) {
        this.lastAnnoPageIdRef.set(lastAnnoPageId);
        this.processedCount = processedCount;
    }

    public ObjectId getLastAnnoPageId() {
        return (ObjectId)this.lastAnnoPageIdRef.get();
    }

    public void setLastAnnoPageId(ObjectId lastAnnoPageId) {
        this.lastAnnoPageIdRef.set(lastAnnoPageId);
    }

    public AtomicLong getProcessedCount() {
        return this.processedCount;
    }

    public long addProcessed(long processedCount) {
        return this.processedCount.addAndGet(processedCount);
    }

    public String toString() {
        return "MigrationJobMetadata{lastAnnoPageId=" + this.lastAnnoPageIdRef.get() + ", processedCount=" + this.processedCount.get() + "}";
    }
}

