/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.migrations.listener;

import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.migrations.config.MigrationAppSettings;
import eu.europeana.fulltext.migrations.model.MigrationJobMetadata;
import eu.europeana.fulltext.migrations.repository.MigrationRepository;
import eu.europeana.fulltext.util.GeneralUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.batch.core.listener.ItemListenerSupport;

public class MigrationProgressListener
extends ItemListenerSupport<AnnoPage, AnnoPage> {
    private static final Logger logger = LogManager.getLogger(MigrationProgressListener.class);
    private final long loggingInterval;
    private final MigrationJobMetadata jobMetadata;
    private final MigrationRepository repository;
    private final long totalDocs;
    private final AtomicLong nextLoggingThreshold;
    private final Object lock = new Object();

    public MigrationProgressListener(MigrationAppSettings appSettings, MigrationJobMetadata jobMetadata, MigrationRepository repository) {
        this.totalDocs = appSettings.getTotalCount();
        this.jobMetadata = jobMetadata;
        this.repository = repository;
        this.loggingInterval = appSettings.getLoggingInterval();
        this.nextLoggingThreshold = new AtomicLong(this.loggingInterval);
    }

    public void onReadError(Exception ex) {
        logger.warn("Error during read", (Throwable)ex);
    }

    public void onProcessError(AnnoPage item, Exception e) {
        logger.warn("Error during processing. {}", (Object)item, (Object)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterWrite(List<? extends AnnoPage> item) {
        long writeCount = this.jobMetadata.addProcessed((long)item.size());
        if (writeCount > this.nextLoggingThreshold.get()) {
            Object object = this.lock;
            synchronized (object) {
                if (writeCount > this.nextLoggingThreshold.get()) {
                    this.nextLoggingThreshold.set(this.nextLoggingThreshold.get() + this.loggingInterval);
                    this.repository.save(this.jobMetadata);
                    logger.info("Saved job metadata checkpoint: {}", (Object)this.jobMetadata);
                    if (this.totalDocs > 0L && logger.isInfoEnabled()) {
                        logger.info("{}% of {} records migrated", (Object)String.format("%.2f", (double)writeCount / (double)this.totalDocs * 100.0), (Object)this.totalDocs);
                    }
                }
            }
        }
    }

    public void onWriteError(Exception ex, List<? extends AnnoPage> annoPages) {
        logger.warn("Error during write. ObjectIds={}", (Object)GeneralUtils.getAnnoPageObjectIds(annoPages), (Object)ex);
    }
}

