/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.migrations.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import dev.morphia.Datastore;
import dev.morphia.Morphia;
import dev.morphia.mapping.MapperOptions;
import eu.europeana.fulltext.migrations.config.MigrationAppSettings;
import eu.europeana.fulltext.migrations.model.AtomicReferenceCodec;
import eu.europeana.fulltext.migrations.model.AtomicReferenceCodecProvider;
import eu.europeana.fulltext.util.MorphiaUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.codecs.pojo.PropertyCodecProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class MigrationDatasourceConfig {
    private final MigrationAppSettings config;
    private static final Logger logger = LogManager.getLogger(MigrationDatasourceConfig.class);
    private Datastore sourceMongoDataStore;

    public MigrationDatasourceConfig(MigrationAppSettings config) {
        this.config = config;
    }

    public MongoClient createMongoClient(String connectionUrl, boolean addCodecProvider) {
        MongoClientSettings.Builder mongoBuilder = MongoClientSettings.builder().applyConnectionString(new ConnectionString(connectionUrl));
        if (addCodecProvider) {
            PojoCodecProvider pojoCodecProvider = PojoCodecProvider.builder().register(new PropertyCodecProvider[]{new AtomicReferenceCodecProvider()}).build();
            CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new AtomicReferenceCodec()}), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{pojoCodecProvider}), MongoClientSettings.getDefaultCodecRegistry()});
            mongoBuilder.codecRegistry(codecRegistry);
        }
        return MongoClients.create((MongoClientSettings)mongoBuilder.build());
    }

    @Bean(value={"fulltextSrcDataStore"})
    @Primary
    public Datastore fulltextSourceDb() {
        String fulltextDatabase = this.config.getFulltextSrcDatabase();
        logger.info("Configuring fulltext database: {}", (Object)fulltextDatabase);
        return Morphia.createDatastore((MongoClient)this.createMongoClient(this.config.getMongoSrcConnectionUrl(), this.config.useSameDb()), (String)fulltextDatabase, (MapperOptions)MorphiaUtils.MAPPER_OPTIONS);
    }

    @Bean(value={"fulltextDestDataStore"})
    public Datastore fulltextDestDb(@Qualifier(value="fulltextSrcDataStore") Datastore srcDataStore) {
        if (this.config.useSameDb()) {
            logger.info("Using the same Mongo db as source and destination");
            return srcDataStore;
        }
        String fulltextDatabase = this.config.getFulltextDestDatabase();
        logger.info("Configuring destination  database: {}", (Object)fulltextDatabase);
        return Morphia.createDatastore((MongoClient)this.createMongoClient(this.config.getMongoDestConnectionUrl(), !this.config.useSameDb()), (String)fulltextDatabase, (MapperOptions)MorphiaUtils.MAPPER_OPTIONS);
    }
}

