/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.migrations.config;

import eu.europeana.fulltext.migrations.config.MigrationAppSettings;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class MigrationBatchBean {
    private final MigrationAppSettings config;

    public MigrationBatchBean(MigrationAppSettings config) {
        this.config = config;
    }

    @Bean(value={"batchThreadExecutor"})
    public TaskExecutor migrationTaskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(this.config.getBatchCorePoolSize());
        taskExecutor.setMaxPoolSize(this.config.getBatchMaxPoolSize());
        taskExecutor.setQueueCapacity(this.config.getBatchQueueSize());
        return taskExecutor;
    }
}

