/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.migrations.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:migrations.properties"}), @PropertySource(value={"classpath:migrations.user.properties"}, ignoreResourceNotFound=true)})
public class MigrationAppSettings {
    @Value(value="${mongo.source.connectionUrl}")
    private String mongoSrcConnectionUrl;
    @Value(value="${mongo.source.fulltext.database}")
    private String fulltextSrcDatabase;
    @Value(value="${mongo.dest.connectionUrl:}")
    private String mongoDestConnectionUrl;
    @Value(value="${mongo.dest.fulltext.database:}")
    private String fulltextDestDatabase;
    @Value(value="${mongo.useSameDb}")
    private boolean useSameDb;
    @Value(value="${batch.pageSize: 100}")
    private int pageSize;
    @Value(value="${batch.executor.corePool: 5}")
    private int batchCorePoolSize;
    @Value(value="${batch.executor.maxPool: 10}")
    private int batchMaxPoolSize;
    @Value(value="${batch.throttleLimit: 5}")
    private int batchThrottleLimit;
    @Value(value="${batch.step.executor.queueSize: 5}")
    private int batchQueueSize;
    @Value(value="${batch.loggingInterval: 1000}")
    private int loggingInterval;
    @Value(value="${batch.skipLimit: 500}")
    private int skipLimit;
    @Value(value="${batch.tooManyAnnotationsThreshold: 5000}")
    private int tooManyAnnotationsThreshold;
    @Value(value="${mongo.fulltext.totalCount:0}")
    private long totalCount;

    public String getMongoSrcConnectionUrl() {
        return this.mongoSrcConnectionUrl;
    }

    public String getFulltextSrcDatabase() {
        return this.fulltextSrcDatabase;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getBatchCorePoolSize() {
        return this.batchCorePoolSize;
    }

    public int getBatchMaxPoolSize() {
        return this.batchMaxPoolSize;
    }

    public int getBatchQueueSize() {
        return this.batchQueueSize;
    }

    public int getBatchThrottleLimit() {
        return this.batchThrottleLimit;
    }

    public int getLoggingInterval() {
        return this.loggingInterval;
    }

    public int getSkipLimit() {
        return this.skipLimit;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public int getTooManyAnnotationsThreshold() {
        return this.tooManyAnnotationsThreshold;
    }

    public String getMongoDestConnectionUrl() {
        return this.mongoDestConnectionUrl;
    }

    public String getFulltextDestDatabase() {
        return this.fulltextDestDatabase;
    }

    public boolean useSameDb() {
        return this.useSameDb;
    }
}

