/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.migrations.writer;

import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.migrations.repository.MigrationRepository;
import eu.europeana.fulltext.util.GeneralUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@Component
public class MigrationAnnoPageWriter
implements ItemWriter<AnnoPage> {
    private final MigrationRepository repository;
    private static final Logger logger = LogManager.getLogger(MigrationAnnoPageWriter.class);

    public MigrationAnnoPageWriter(MigrationRepository repository) {
        this.repository = repository;
    }

    public void write(@NotNull List<? extends AnnoPage> annoPages) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AnnoPage write starting..., objectIds={}", (Object)Arrays.toString(GeneralUtils.getAnnoPageObjectIds(annoPages)));
        }
        List resources = annoPages.stream().map(AnnoPage::getRes).collect(Collectors.toList());
        this.repository.save(resources);
        this.repository.upsertAnnoPages(annoPages);
        List oldDbIds = annoPages.stream().filter(a -> !Objects.equals(a.getRes().getOldDbId(), a.getRes().getId())).map(a -> a.getRes().getOldDbId()).collect(Collectors.toList());
        this.repository.deleteResource(oldDbIds);
    }
}

