/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.migrations.repository;

import com.mongodb.DBRef;
import com.mongodb.client.model.UpdateOneModel;
import dev.morphia.Datastore;
import dev.morphia.UpdateOptions;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Query;
import dev.morphia.query.Sort;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.Filters;
import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.entity.Annotation;
import eu.europeana.fulltext.entity.Resource;
import eu.europeana.fulltext.exception.DatabaseQueryException;
import eu.europeana.fulltext.migrations.config.MigrationAppSettings;
import eu.europeana.fulltext.migrations.model.MigrationJobMetadata;
import eu.europeana.fulltext.util.MorphiaUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class MigrationRepository {
    private final Datastore sourceDataStore;
    private final Datastore destinationDataStore;
    private final int tooManyAnnotationsThreshold;
    private static final Logger logger = LogManager.getLogger(MigrationRepository.class);

    public MigrationRepository(@Qualifier(value="fulltextSrcDataStore") Datastore sourceDataStore, @Qualifier(value="fulltextDestDataStore") Datastore destinationDataStore, MigrationAppSettings settings) {
        this.sourceDataStore = sourceDataStore;
        this.destinationDataStore = destinationDataStore;
        this.tooManyAnnotationsThreshold = settings.getTooManyAnnotationsThreshold();
    }

    public List<AnnoPage> getAnnoPages(int count, @Nullable ObjectId objectId, boolean useProjection) {
        Query findQuery = this.sourceDataStore.find(AnnoPage.class);
        if (objectId != null) {
            findQuery.filter(new Filter[]{Filters.gt((String)"_id", (Object)objectId)});
        }
        FindOptions findOpts = new FindOptions().limit(count);
        if (useProjection) {
            findOpts.projection().include(new String[]{"tgtId", "res"}).sort(new Sort[]{Sort.ascending((String)"_id")});
        }
        return findQuery.iterator(findOpts).toList();
    }

    public List<AnnoPage> getAnnoPagesModifiedBefore(Date date, int skip, int limit) {
        return this.sourceDataStore.find(AnnoPage.class).filter(new Filter[]{Filters.lt((String)"modified", (Object)date)}).iterator(new FindOptions().skip(skip).limit(limit)).toList();
    }

    public void upsertAnnoPages(List<? extends AnnoPage> annoPageList) throws DatabaseQueryException {
        ArrayList<UpdateOneModel> annoPageUpdates = new ArrayList<UpdateOneModel>();
        Instant now = Instant.now();
        ArrayList<AnnoPage> annoPagesWithManyAnnotations = new ArrayList<AnnoPage>();
        for (AnnoPage annoPage : annoPageList) {
            boolean hasManyAnnotations;
            Resource res = annoPage.getRes();
            boolean bl = hasManyAnnotations = annoPage.getAns().size() > this.tooManyAnnotationsThreshold;
            if (res == null) {
                throw new DatabaseQueryException("res is null for " + annoPage);
            }
            Document updateDoc = new Document("dsId", (Object)annoPage.getDsId()).append("lcId", (Object)annoPage.getLcId()).append("pgId", (Object)annoPage.getPgId()).append("tgtId", (Object)annoPage.getTgtId()).append("modified", (Object)now).append("lang", (Object)annoPage.getLang()).append("res", (Object)new DBRef(MorphiaUtils.RESOURCE_COL, (Object)res.getId()));
            if (annoPage.getSource() != null) {
                updateDoc.append("source", (Object)annoPage.getSource());
            }
            if (annoPage.isTranslation()) {
                updateDoc.append("translation", (Object)annoPage.isTranslation());
            }
            if (!hasManyAnnotations) {
                updateDoc.append("ans", (Object)annoPage.getAns());
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("AnnoPage {} has {} annotations; these will be updated separately; threshold is {}", (Object)annoPage.getDbId(), (Object)annoPage.getAns().size(), (Object)this.tooManyAnnotationsThreshold);
                }
                annoPagesWithManyAnnotations.add(annoPage);
            }
            annoPageUpdates.add(new UpdateOneModel((Bson)new Document("_id", (Object)annoPage.getDbId()), (Bson)new Document("$set", (Object)updateDoc).append("$unset", (Object)new Document("className", (Object)"")), (com.mongodb.client.model.UpdateOptions)MorphiaUtils.UPSERT_OPTS));
        }
        this.updateAnnotations(annoPagesWithManyAnnotations);
        this.destinationDataStore.getMapper().getCollection(AnnoPage.class).bulkWrite(annoPageUpdates);
    }

    private void updateAnnotations(List<AnnoPage> annoPagesWithManyAnnotations) {
        for (AnnoPage annoPage : annoPagesWithManyAnnotations) {
            AtomicInteger counter = new AtomicInteger();
            Stream annotationStream = annoPage.getAns().stream();
            Document filter = new Document("_id", (Object)annoPage.getDbId());
            Collection<List<Annotation>> annotationChunks = annotationStream.collect(Collectors.groupingBy(it -> counter.getAndIncrement() / this.tooManyAnnotationsThreshold)).values();
            int chunkCount = 1;
            for (List<Annotation> annotations : annotationChunks) {
                List annotationUpdate = annotations.stream().map(annotation -> new UpdateOneModel((Bson)filter, (Bson)new Document("$set", (Object)new Document("ans.$[elem].anId", (Object)annotation.getAnId())), (com.mongodb.client.model.UpdateOptions)new UpdateOptions().arrayFilter(Filters.eq((String)"elem.anId", (Object)annotation.getOldAnId())))).collect(Collectors.toList());
                this.destinationDataStore.getMapper().getCollection(AnnoPage.class).bulkWrite(annotationUpdate);
                if (logger.isDebugEnabled()) {
                    logger.debug("Updated annotations for AnnoPage {}; chunk {} of {}, chunkSize={}, annotations={} ", (Object)annoPage.getDbId(), (Object)chunkCount, (Object)annotationChunks.size(), (Object)annotations.size(), (Object)annoPage.getAns().size());
                }
                ++chunkCount;
            }
        }
    }

    public void deleteResource(List<String> resourceIds) {
        this.destinationDataStore.find(Resource.class).filter(new Filter[]{Filters.in((String)"_id", resourceIds)}).delete(MorphiaUtils.MULTI_DELETE_OPTS);
    }

    public void save(List<Resource> resources) {
        ArrayList<UpdateOneModel> resourceUpdates = new ArrayList<UpdateOneModel>();
        for (Resource res : resources) {
            Document updateDoc = new Document("dsId", (Object)res.getDsId()).append("lcId", (Object)res.getLcId()).append("lang", (Object)res.getLang()).append("value", (Object)res.getValue()).append("rights", (Object)res.getRights()).append("pgId", (Object)res.getPgId());
            if (res.isTranslation()) {
                updateDoc.append("translation", (Object)res.isTranslation());
            }
            resourceUpdates.add(new UpdateOneModel((Bson)new Document(Map.of("dsId", res.getDsId(), "lcId", res.getLcId(), "lang", res.getLang(), "_id", res.getId())), (Bson)new Document("$set", (Object)updateDoc).append("$setOnInsert", (Object)new Document("_id", (Object)res.getId())), (com.mongodb.client.model.UpdateOptions)MorphiaUtils.UPSERT_OPTS));
        }
        this.destinationDataStore.getMapper().getCollection(Resource.class).bulkWrite(resourceUpdates);
    }

    public MigrationJobMetadata getExistingMetadata() {
        return (MigrationJobMetadata)this.destinationDataStore.find(MigrationJobMetadata.class).filter(new Filter[]{Filters.exists((String)"lastAnnoPageIdRef")}).iterator().tryNext();
    }

    public void save(MigrationJobMetadata jobMetadata) {
        this.destinationDataStore.save((Object)jobMetadata);
    }

    public void updateResourcePgId(List<Resource> resources) {
        ArrayList<UpdateOneModel> resourceUpdates = new ArrayList<UpdateOneModel>();
        for (Resource res : resources) {
            resourceUpdates.add(new UpdateOneModel((Bson)new Document(Map.of("_id", res.getId())), (Bson)new Document("$set", (Object)new Document("pgId", (Object)res.getPgId()))));
        }
        this.destinationDataStore.getMapper().getCollection(Resource.class).bulkWrite(resourceUpdates);
    }

    public void updateAnnoPageId(List<? extends AnnoPage> annoPages) {
        ArrayList<UpdateOneModel> annoPageUpdates = new ArrayList<UpdateOneModel>();
        for (AnnoPage annoPage : annoPages) {
            annoPageUpdates.add(new UpdateOneModel((Bson)new Document(Map.of("_id", annoPage.getDbId())), (Bson)new Document("$set", (Object)new Document("pgId", (Object)annoPage.getPgId()))));
        }
        this.destinationDataStore.getMapper().getCollection(AnnoPage.class).bulkWrite(annoPageUpdates);
    }
}

