/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.migrations.processor;

import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.entity.Annotation;
import eu.europeana.fulltext.entity.Resource;
import eu.europeana.fulltext.util.GeneralUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
public class MigrationAnnoPageProcessor
implements ItemProcessor<AnnoPage, AnnoPage> {
    public AnnoPage process(@NotNull AnnoPage annoPage) throws Exception {
        String pageId = GeneralUtils.derivePageId((String)annoPage.getTgtId());
        annoPage.setPgId(pageId);
        for (Annotation a : annoPage.getAns()) {
            a.setOldAnId(a.getAnId());
            String annoId = GeneralUtils.createAnnotationHash((Annotation)a, (String)annoPage.getTgtId(), (String)annoPage.getLang());
            a.setAnId(annoId);
        }
        Resource res = annoPage.getRes();
        String oldDbId = res.getId();
        res.setOldDbId(oldDbId);
        res.setId(GeneralUtils.generateResourceId((String)GeneralUtils.generateRecordId((String)annoPage.getDsId(), (String)annoPage.getLcId()), (String)annoPage.getLang(), (String)annoPage.getTgtId()));
        res.setPgId(pageId);
        return annoPage;
    }
}

