/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.migrations;

import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.migrations.config.MigrationAppSettings;
import eu.europeana.fulltext.migrations.listener.MigrationProgressListener;
import eu.europeana.fulltext.migrations.listener.MigrationSkipListener;
import eu.europeana.fulltext.migrations.model.MigrationJobMetadata;
import eu.europeana.fulltext.migrations.processor.MigrationAnnoPageProcessor;
import eu.europeana.fulltext.migrations.reader.MigrationAnnoPageReader;
import eu.europeana.fulltext.migrations.repository.MigrationRepository;
import eu.europeana.fulltext.migrations.writer.MigrationAnnoPageWriter;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStreamReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.support.SynchronizedItemStreamReader;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class MigrationBatchConfig {
    private final JobBuilderFactory jobs;
    private final StepBuilderFactory steps;
    private final TaskExecutor migrationTaskExecutor;
    private final MigrationAppSettings appSettings;
    private final MigrationRepository repository;
    private final MigrationAnnoPageProcessor processor;
    private final MigrationSkipListener skipListener;
    private static final Logger logger = LogManager.getLogger(MigrationBatchConfig.class);
    private final MigrationAnnoPageWriter writer;

    public MigrationBatchConfig(JobBuilderFactory jobs, StepBuilderFactory steps, @Qualifier(value="batchThreadExecutor") TaskExecutor migrationTaskExecutor, MigrationAppSettings appSettings, MigrationRepository repository, MigrationAnnoPageProcessor processor, MigrationSkipListener skipListener, MigrationAnnoPageWriter writer) {
        this.jobs = jobs;
        this.steps = steps;
        this.migrationTaskExecutor = migrationTaskExecutor;
        this.appSettings = appSettings;
        this.repository = repository;
        this.processor = processor;
        this.skipListener = skipListener;
        this.writer = writer;
    }

    private ItemReader<AnnoPage> annoPageReader(MigrationJobMetadata jobMetadata) {
        return this.threadSafeReader((ItemStreamReader)new MigrationAnnoPageReader(this.appSettings.getPageSize(), this.repository, jobMetadata));
    }

    private <T> SynchronizedItemStreamReader<T> threadSafeReader(ItemStreamReader<T> reader) {
        SynchronizedItemStreamReader synchronizedItemStreamReader = new SynchronizedItemStreamReader();
        synchronizedItemStreamReader.setDelegate(reader);
        return synchronizedItemStreamReader;
    }

    private MigrationProgressListener reportingListener(MigrationJobMetadata jobMetadata) {
        return new MigrationProgressListener(this.appSettings, jobMetadata, this.repository);
    }

    private Step migrateAnnoPageStep(MigrationJobMetadata jobMetadata) {
        return this.steps.get("migrateAnnoPageStep").chunk(this.appSettings.getPageSize()).reader(this.annoPageReader(jobMetadata)).processor((ItemProcessor)this.processor).writer((ItemWriter)this.writer).faultTolerant().skip(Exception.class).skipLimit(this.appSettings.getSkipLimit()).listener((ItemReadListener)this.reportingListener(jobMetadata)).listener((Object)this.skipListener).taskExecutor(this.migrationTaskExecutor).throttleLimit(this.appSettings.getBatchThrottleLimit()).build();
    }

    @Bean
    private Job migrateAnnoPageJob() {
        MigrationJobMetadata jobMetadata = this.repository.getExistingMetadata();
        if (jobMetadata != null) {
            logger.info("Found existing job metadata. Will resume processing from: {}", (Object)jobMetadata);
        } else {
            logger.info("No existing metadata found. Starting processing from scratch");
            jobMetadata = new MigrationJobMetadata(null, new AtomicLong());
        }
        return ((JobBuilder)((JobBuilder)this.jobs.get("migrateAnnoPageJob").preventRestart()).incrementer(p -> new JobParametersBuilder().addDate("startTime", new Date()).toJobParameters())).start(this.migrateAnnoPageStep(jobMetadata)).build();
    }
}

