/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.search.model.response.v3;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import eu.europeana.fulltext.api.model.v3.AnnotationV3;
import eu.europeana.fulltext.api.service.EDM2IIIFMapping;
import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.entity.Annotation;
import eu.europeana.fulltext.search.model.response.Debug;
import eu.europeana.fulltext.search.model.response.Hit;
import eu.europeana.fulltext.search.model.response.SearchResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonPropertyOrder(value={"context", "id", "type", "debug", "items", "hits"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchResultV3
implements Serializable,
SearchResult {
    private static final long serialVersionUID = -5643549600050178321L;
    private static final String TYPE = "AnnotationPage";
    private String[] context;
    private String id;
    private Debug debug;
    private List<AnnotationV3> items = new ArrayList<AnnotationV3>();
    private List<Hit> hits = new ArrayList<Hit>();

    public SearchResultV3(String searchId, boolean debug) {
        this.id = searchId;
        if (debug) {
            this.debug = new Debug();
        }
    }

    @Override
    public String[] getContext() {
        return this.context;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Debug getDebug() {
        return this.debug;
    }

    @Override
    public int itemSize() {
        return this.items.size();
    }

    public List<AnnotationV3> getItems() {
        return this.items;
    }

    @Override
    public List<Hit> getHits() {
        return this.hits;
    }

    @Override
    public void setContext(String[] context) {
    }

    @Override
    public void addAnnotationHit(AnnoPage annoPage, Annotation annotation, Hit hit) {
        AnnotationV3 annoV3 = EDM2IIIFMapping.getAnnotationV3(annoPage, annotation, false, false);
        this.items.add(annoV3);
        if (hit != null) {
            this.hits.add(hit);
        }
    }
}

