/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.web;

import eu.europeana.api.commons.error.EuropeanaApiErrorResponse;
import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.api.commons.web.exception.EuropeanaGlobalExceptionHandler;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.util.Strings;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@ControllerAdvice
@EnableWebMvc
public class FTExceptionHandler
extends EuropeanaGlobalExceptionHandler {
    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<EuropeanaApiErrorResponse> handleHttpMessageNotReadableException(HttpMessageNotReadableException e, HttpServletRequest httpRequest) {
        HttpStatus responseStatus = HttpStatus.BAD_REQUEST;
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(responseStatus.value()).setError(responseStatus.getReasonPhrase()).setMessage("Required request body is missing").build();
        return ResponseEntity.status((HttpStatus)responseStatus).contentType(MediaType.APPLICATION_JSON).body((Object)response);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ResponseEntity<EuropeanaApiErrorResponse> handleMethodArgumentTypeMismatchException(MethodArgumentTypeMismatchException e, HttpServletRequest httpRequest) {
        HttpStatus responseStatus = HttpStatus.BAD_REQUEST;
        String errorMessage = String.format("'%s' should be of type %s", e.getName(), e.getParameter().getGenericParameterType().getTypeName());
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(responseStatus.value()).setError(responseStatus.getReasonPhrase()).setMessage(errorMessage).build();
        return ResponseEntity.status((HttpStatus)responseStatus).contentType(MediaType.APPLICATION_JSON).body((Object)response);
    }

    @ExceptionHandler
    public ResponseEntity<EuropeanaApiErrorResponse> handleApplicationAuthenticationException(ApplicationAuthenticationException e, HttpServletRequest httpRequest) {
        HttpStatus responseStatus = HttpStatus.UNAUTHORIZED;
        EuropeanaApiErrorResponse errorResponse = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(responseStatus.value()).setError(responseStatus.getReasonPhrase()).setMessage(Strings.join(Arrays.asList(e.getI18nParams()), (char)',')).build();
        return ResponseEntity.status((HttpStatus)responseStatus).contentType(MediaType.APPLICATION_JSON).body((Object)errorResponse);
    }
}

