/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.service;

import eu.europeana.fulltext.AnnotationType;
import eu.europeana.fulltext.search.exception.InvalidParameterException;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class ControllerUtils {
    private ControllerUtils() {
    }

    public static List<AnnotationType> validateTextGranularity(String textGranularityParams, Set<AnnotationType> allowedTypes) throws InvalidParameterException {
        if (StringUtils.isBlank((String)textGranularityParams)) {
            return Collections.emptyList();
        }
        String[] values = textGranularityParams.split("\\+|\\s|,");
        ArrayList<AnnotationType> result = new ArrayList<AnnotationType>();
        for (String value : values) {
            AnnotationType type = AnnotationType.fromAbbreviationOrName((String)value);
            if (!allowedTypes.stream().anyMatch(x -> x.equals((Object)type))) {
                throw new InvalidParameterException("invalid text granularity value '" + value + "'. Allowed values are " + String.valueOf(allowedTypes));
            }
            result.add(type);
        }
        return result;
    }
}

