/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.config;

import eu.europeana.fulltext.AnnotationType;
import eu.europeana.fulltext.api.service.ControllerUtils;
import eu.europeana.fulltext.search.exception.InvalidParameterException;
import eu.europeana.fulltext.search.web.FTSearchController;
import eu.europeana.fulltext.util.GeneralUtils;
import eu.europeana.fulltext.util.SettingsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.env.Environment;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:fulltext.properties"}), @PropertySource(value={"classpath:fulltext.user.properties"}, ignoreResourceNotFound=true)})
public class FTSettings
implements InitializingBean {
    private static final Logger LOG = LogManager.getLogger(FTSettings.class);
    private Boolean suppressParseException = false;
    @Value(value="${annopage.baseurl}")
    private String annoPageBaseUrl;
    @Value(value="${annotation.baseurl}")
    private String annotationBaseUrl;
    @Value(value="${resource.baseurl}")
    private String resourceBaseUrl;
    @Value(value="${search.baseurl}")
    private String searchBaseUrl;
    @Value(value="${search.textGranularity.default:Word}")
    private String searchTextGranularity;
    private List<AnnotationType> defaultSearchTextGranularity;
    @Value(value="${spring.profiles.active:}")
    private String activeProfileString;
    @Value(value="${auth.enabled}")
    private boolean authEnabled;
    @Value(value="${europeana.apikey.jwttoken.signaturekey}")
    private String apiKeyPublicKey;
    @Value(value="${authorization.api.name}")
    private String authorizationApiName;
    @Value(value="${europeana.apikey.serviceurl}")
    private String apiKeyUrl;
    @Value(value="${mongo.connectionUrl}")
    private String mongoConnectionUrl;
    @Value(value="${mongo.fulltext.database}")
    private String fulltextDatabase;
    @Value(value="${mongo.fulltext.ensureIndices: false}")
    private boolean ensureFulltextIndices;
    @Value(value="${webclient.maxBufferMb:16}")
    private int maxBufferMb;
    @Value(value="${annotations.id.hosts}")
    private String annotationIdHostsPattern;
    @Value(value="${annotations.wskey}")
    private String annotationsApiKey;
    @Value(value="${spring.data.solr.repositories.enabled}")
    private boolean solrEnabled;
    @Autowired
    private Environment environment;

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public String getAuthorizationApiName() {
        return this.authorizationApiName;
    }

    public String getApiKeyPublicKey() {
        return this.apiKeyPublicKey;
    }

    public String getApiKeyUrl() {
        return this.apiKeyUrl;
    }

    public String getMongoConnectionUrl() {
        return this.mongoConnectionUrl;
    }

    public String getFulltextDatabase() {
        return this.fulltextDatabase;
    }

    public boolean ensureFulltextIndices() {
        return this.ensureFulltextIndices;
    }

    public String getAnnotationsApiKey() {
        return this.annotationsApiKey;
    }

    public String getAnnotationIdHostsPattern() {
        return this.annotationIdHostsPattern;
    }

    private void setupTextGranularity() throws InvalidParameterException {
        if (StringUtils.isBlank((CharSequence)this.searchTextGranularity)) {
            LOG.info("No default text granularity for search found in configuration files");
            this.defaultSearchTextGranularity = Arrays.asList(AnnotationType.LINE);
        } else {
            this.defaultSearchTextGranularity = ControllerUtils.validateTextGranularity(this.searchTextGranularity, FTSearchController.ALLOWED_ANNOTATION_TYPES);
        }
        LOG.info("Default text granularity for search = {}", (Object)this.searchTextGranularity);
    }

    public Boolean getSuppressParseException() {
        return this.suppressParseException;
    }

    public String getAppVersion() {
        Properties buildProperties = new Properties();
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/build.properties");
        try {
            buildProperties.load(resourceAsStream);
            return this.environment.getProperty("info.app.version");
        }
        catch (IOException e) {
            LogManager.getLogger(FTSettings.class).warn("Error loading build.properties", (Throwable)e);
            return "default";
        }
    }

    public String getAnnoPageBaseUrl() {
        return this.annoPageBaseUrl;
    }

    public String getAnnotationBaseUrl() {
        return this.annotationBaseUrl;
    }

    public String getResourceBaseUrl() {
        return this.resourceBaseUrl;
    }

    public String getSearchBaseUrl() {
        return this.searchBaseUrl;
    }

    public List<AnnotationType> getDefaultSearchTextGranularity() {
        return Collections.unmodifiableList(this.defaultSearchTextGranularity);
    }

    public void afterPropertiesSet() throws Exception {
        if (GeneralUtils.testProfileNotActive((String)this.activeProfileString)) {
            this.validateRequiredSettings();
        }
        this.setupTextGranularity();
    }

    private void validateRequiredSettings() {
        ArrayList missingProps = new ArrayList();
        HashMap<String, String> singleValidations = new HashMap<String, String>();
        singleValidations.put(this.annotationsApiKey, "annotations.wskey");
        singleValidations.put(this.apiKeyPublicKey, "europeana.apikey.jwttoken.signaturekey");
        singleValidations.put(this.apiKeyUrl, "europeana.apikey.serviceurl");
        SettingsUtils.validateValues(singleValidations, missingProps);
        if (this.authEnabled) {
            SettingsUtils.validateValues(Map.of(this.authorizationApiName, "authorization.api.name", this.apiKeyUrl, "europeana.apikey.serviceurl", this.apiKeyPublicKey, "europeana.apikey.jwttoken.signaturekey"), missingProps);
        }
        if (!missingProps.isEmpty()) {
            throw new IllegalStateException(String.format("The following config properties are not set: %s", String.join((CharSequence)"\n", missingProps)));
        }
    }

    public boolean isSolrEnabled() {
        return this.solrEnabled;
    }

    public int getMaxBufferMb() {
        return this.maxBufferMb;
    }
}

