/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.util;

import eu.europeana.fulltext.exception.InvalidRequestParamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class RequestUtils {
    public static final String PROFILE_TEXT = "text";
    public static final String PROFILE_DEBUG = "debug";

    public static List<String> extractProfiles(String profileParam) throws InvalidRequestParamException {
        List<String> profiles = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)profileParam)) {
            profiles = Arrays.asList(StringUtils.split((String)profileParam, (String)","));
            for (String val : profiles) {
                if (StringUtils.equals((CharSequence)val, (CharSequence)PROFILE_TEXT) || StringUtils.equals((CharSequence)val, (CharSequence)PROFILE_DEBUG)) continue;
                throw new InvalidRequestParamException("profile", val);
            }
        }
        return profiles;
    }

    public static String escapeQueryChars(String s) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (Character.isWhitespace(c) || Set.of(Character.valueOf('\\'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('!'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf(':'), Character.valueOf('^'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('~'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('|'), Character.valueOf('&'), Character.valueOf(';'), Character.valueOf('/')).contains(Character.valueOf(c))) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

