/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.search.model.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import eu.europeana.fulltext.api.service.EDM2IIIFMapping;
import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.entity.Annotation;
import eu.europeana.fulltext.search.model.query.EuropeanaId;
import eu.europeana.fulltext.search.model.response.HitSelector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonPropertyOrder(value={"type", "annotations", "selectors"})
public abstract class Hit
implements Serializable {
    private static final long serialVersionUID = -3280544584499568202L;
    private Integer startIndex;
    private Integer endIndex;
    private List<String> annotations = new ArrayList<String>();
    private List<HitSelector> selectors = new ArrayList<HitSelector>();

    public abstract String getType();

    @JsonIgnore
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @JsonIgnore
    public Integer getEndIndex() {
        return this.endIndex;
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public List<HitSelector> getSelectors() {
        return this.selectors;
    }

    public Hit addAnnotation(int start, int end, AnnoPage annoPage, Annotation annotation) {
        HitSelector hs;
        String fulltext = annoPage.getRes().getValue();
        if (this.selectors.isEmpty()) {
            this.startIndex = start;
            this.endIndex = end;
            hs = this.createSelector(fulltext.substring(start, end));
            this.selectors.add(hs);
            if (annotation.getFrom() < this.startIndex) {
                hs.setPrefix(fulltext.substring(annotation.getFrom(), this.startIndex));
            }
        } else {
            hs = this.selectors.get(0);
        }
        if (this.endIndex < annotation.getTo()) {
            hs.setSuffix(fulltext.substring(this.endIndex, annotation.getTo()));
        }
        EuropeanaId id = new EuropeanaId(annoPage.getDsId(), annoPage.getLcId());
        this.annotations.add(EDM2IIIFMapping.getAnnotationIdUrl(id.toString(), annotation));
        return this;
    }

    protected abstract HitSelector createSelector(String var1);
}

