/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.service;

import eu.europeana.fulltext.AnnotationType;
import eu.europeana.fulltext.api.config.FTDefinitions;
import eu.europeana.fulltext.api.config.FTSettings;
import eu.europeana.fulltext.api.model.FTResource;
import eu.europeana.fulltext.api.model.v2.AnnotationBodyV2;
import eu.europeana.fulltext.api.model.v2.AnnotationFullBodyV2;
import eu.europeana.fulltext.api.model.v2.AnnotationPageV2;
import eu.europeana.fulltext.api.model.v2.AnnotationV2;
import eu.europeana.fulltext.api.model.v3.AnnotationBodyV3;
import eu.europeana.fulltext.api.model.v3.AnnotationPageV3;
import eu.europeana.fulltext.api.model.v3.AnnotationV3;
import eu.europeana.fulltext.api.service.FTService;
import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.entity.Annotation;
import eu.europeana.fulltext.entity.Resource;
import eu.europeana.fulltext.entity.Target;
import eu.europeana.fulltext.exception.ResourceDoesNotExistException;
import eu.europeana.fulltext.util.NormalPlayTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class EDM2IIIFMapping {
    private static FTSettings fts;
    private static FTService ftService;
    private static final String V2_MOTIVATION = "sc:painting";
    private static final String V3_MOTIVATION = "transcribing";
    private static final Logger LOG;

    @Autowired
    private EDM2IIIFMapping(FTSettings fts, FTService ftService) {
        EDM2IIIFMapping.fts = fts;
        EDM2IIIFMapping.ftService = ftService;
    }

    static AnnotationPageV2 getAnnotationPageV2(AnnoPage annoPage, List<AnnotationType> textGranValues, boolean derefResource) {
        AnnotationPageV2 annPage = new AnnotationPageV2(EDM2IIIFMapping.getAnnoPageIdUrl(annoPage));
        annPage.setLanguage(annoPage.getLang());
        annPage.setSource(annoPage.getSource());
        annPage.setResources(EDM2IIIFMapping.getAnnotationV2Array(annoPage, derefResource));
        annPage.setTextGranularity(EDM2IIIFMapping.findTextGranularitiesV2(textGranValues, annPage));
        return annPage;
    }

    private static AnnotationV2[] getAnnotationV2Array(AnnoPage annoPage, boolean derefResource) {
        ArrayList<AnnotationV2> annoArrayList = new ArrayList<AnnotationV2>();
        for (Annotation ftAnno : annoPage.getAns()) {
            EDM2IIIFMapping.addAnnotationV2(annoPage, ftAnno, derefResource, annoArrayList);
        }
        return annoArrayList.toArray(new AnnotationV2[0]);
    }

    private static void addAnnotationV2(AnnoPage annoPage, Annotation ftAnno, boolean derefResource, ArrayList<AnnotationV2> annoArrayList) {
        if (ftAnno.isTopLevel()) {
            annoArrayList.add(0, EDM2IIIFMapping.getAnnotationV2(annoPage, ftAnno, false, derefResource));
        } else {
            annoArrayList.add(EDM2IIIFMapping.getAnnotationV2(annoPage, ftAnno, false, false));
        }
    }

    public static AnnotationV2 getAnnotationV2(AnnoPage annoPage, Annotation annotation, boolean includeContext, boolean derefResource) {
        AnnotationBodyV2 anb;
        String resourceIdUrl = EDM2IIIFMapping.getResourceIdUrl(annoPage, annotation);
        AnnotationV2 ann = new AnnotationV2(EDM2IIIFMapping.getAnnotationIdUrl(annoPage, annotation));
        if (includeContext) {
            ann.setContext(new String[]{"http://iiif.io/api/presentation/2/context.json", "http://iiif.io/api/extension/text-granularity/context.json", "https://www.europeana.eu/schemas/context/edm.jsonld"});
        }
        ann.setMotivation(StringUtils.isNotBlank((CharSequence)annotation.getMotiv()) ? annotation.getMotiv() : V2_MOTIVATION);
        ann.setTextGranularity(EDM2IIIFMapping.dcTypeToTextGranularity(annotation.getDcType()));
        ann.setOn(EDM2IIIFMapping.getFTTargetArray(annoPage, annotation));
        if (StringUtils.isNotBlank((CharSequence)annotation.getLang())) {
            anb = new AnnotationFullBodyV2(resourceIdUrl);
            anb.setFull(EDM2IIIFMapping.getResourceIdBaseUrl(annoPage));
            anb.setLanguage(annotation.getLang());
        } else {
            FTResource ftResource;
            anb = new AnnotationBodyV2(resourceIdUrl);
            if (derefResource && (ftResource = EDM2IIIFMapping.fetchFTResource(annoPage)) != null) {
                anb.setType(ftResource.getType());
                anb.setLanguage(ftResource.getLanguage());
                anb.setValue(ftResource.getValue());
                anb.setSource(ftResource.getSource());
                anb.setEdmRights(ftResource.getRights());
            }
        }
        ann.setResource(anb);
        return ann;
    }

    static AnnotationV2 getSingleAnnotationV2(AnnoPage annoPage, String annoId, boolean profileText) {
        Optional<Annotation> maybe = annoPage.getAns().stream().filter(o -> o.getAnId().equals(annoId)).findFirst();
        return maybe.map(annotation1 -> EDM2IIIFMapping.getAnnotationV2(annoPage, annotation1, true, profileText && annotation1.isTopLevel())).orElse(null);
    }

    private static String[] findTextGranularitiesV2(List<AnnotationType> granularities, AnnotationPageV2 annPage) {
        ArrayList<String> foundGranularities = new ArrayList<String>();
        if (null == granularities || granularities.isEmpty()) {
            granularities = annPage.getResources()[0].isMedia() ? List.copyOf(FTDefinitions.MEDIA_ANNOTATION_TYPES) : List.copyOf(FTDefinitions.TEXT_ANNOTATION_TYPES);
        }
        HashMap<AnnotationType, Boolean> granularityMap = new HashMap<AnnotationType, Boolean>();
        for (AnnotationType annotationType : granularities) {
            granularityMap.put(annotationType, Boolean.FALSE);
        }
        for (AnnotationV2 ann : annPage.getResources()) {
            granularityMap.put(ann.getAnnotationType(), Boolean.TRUE);
            if (!granularityMap.containsValue(Boolean.FALSE)) break;
        }
        for (Map.Entry entry : granularityMap.entrySet()) {
            if (!((Boolean)entry.getValue()).equals(Boolean.TRUE)) continue;
            foundGranularities.add(((AnnotationType)entry.getKey()).getLowerCaseName());
        }
        return foundGranularities.toArray(new String[0]);
    }

    static AnnotationPageV3 getAnnotationPageV3(AnnoPage annoPage, List<AnnotationType> textGranValues, boolean derefResource) {
        AnnotationPageV3 annPage = new AnnotationPageV3(EDM2IIIFMapping.getAnnoPageIdUrl(annoPage));
        annPage.setLanguage(annoPage.getLang());
        annPage.setSource(annoPage.getSource());
        annPage.setItems(EDM2IIIFMapping.getAnnotationV3Array(annoPage, derefResource));
        annPage.setTextGranularity(EDM2IIIFMapping.findTextGranularitiesV3(textGranValues, annPage));
        return annPage;
    }

    private static AnnotationV3[] getAnnotationV3Array(AnnoPage annoPage, boolean derefResource) {
        ArrayList<AnnotationV3> annoArrayList = new ArrayList<AnnotationV3>();
        for (Annotation ftAnno : annoPage.getAns()) {
            EDM2IIIFMapping.addAnnotationV3(annoPage, ftAnno, derefResource, annoArrayList);
        }
        return annoArrayList.toArray(new AnnotationV3[0]);
    }

    private static void addAnnotationV3(AnnoPage annoPage, Annotation ftAnno, boolean derefResource, ArrayList<AnnotationV3> annoArrayList) {
        if (ftAnno.isTopLevel()) {
            annoArrayList.add(0, EDM2IIIFMapping.getAnnotationV3(annoPage, ftAnno, false, derefResource));
        } else {
            annoArrayList.add(EDM2IIIFMapping.getAnnotationV3(annoPage, ftAnno, false, false));
        }
    }

    public static AnnotationV3 getAnnotationV3(AnnoPage annoPage, Annotation annotation, boolean includeContext, boolean derefResource) {
        AnnotationBodyV3 anb;
        String body = EDM2IIIFMapping.getResourceIdUrl(annoPage, annotation);
        AnnotationV3 ann = new AnnotationV3(EDM2IIIFMapping.getAnnotationIdUrl(annoPage, annotation));
        if (includeContext) {
            ann.setContext(new String[]{"http://iiif.io/api/presentation/3/context.json", "http://iiif.io/api/extension/text-granularity/context.json", "https://www.europeana.eu/schemas/context/edm.jsonld"});
        }
        ann.setMotivation(StringUtils.isNotBlank((CharSequence)annotation.getMotiv()) ? annotation.getMotiv() : V3_MOTIVATION);
        ann.setTextGranularity(EDM2IIIFMapping.dcTypeToTextGranularity(annotation.getDcType()));
        if (StringUtils.isNotBlank((CharSequence)annotation.getLang())) {
            anb = new AnnotationBodyV3(body, "SpecificResource");
            anb.setSource(EDM2IIIFMapping.getResourceIdBaseUrl(annoPage));
            anb.setLanguage(annotation.getLang());
        } else {
            FTResource ftResource;
            anb = new AnnotationBodyV3(body);
            if (derefResource && (ftResource = EDM2IIIFMapping.fetchFTResource(annoPage)) != null) {
                anb.setType(ftResource.getType());
                anb.setLanguage(ftResource.getLanguage());
                anb.setValue(ftResource.getValue());
                anb.setSource(ftResource.getSource());
                anb.setEdmRights(ftResource.getRights());
            }
        }
        ann.setBody(anb);
        ann.setTarget(EDM2IIIFMapping.getFTTargetArray(annoPage, annotation));
        return ann;
    }

    static String[] getTextGranularitiesForSummary(AnnoPage annoPage) {
        AnnotationPageV3 annPage = new AnnotationPageV3(EDM2IIIFMapping.getAnnoPageIdUrl(annoPage));
        annPage.setItems(EDM2IIIFMapping.getAnnotationV3Array(annoPage, false));
        ArrayList<String> foundGranularities = new ArrayList<String>();
        for (String foundGranularity : annoPage.getTextGranularity()) {
            foundGranularities.add(AnnotationType.fromAbbreviationOrName((String)foundGranularity).getLowerCaseName());
        }
        return foundGranularities.toArray(new String[0]);
    }

    private static String[] findTextGranularitiesV3(List<AnnotationType> granularities, AnnotationPageV3 annPage) {
        ArrayList<String> foundGranularities = new ArrayList<String>();
        if (null == granularities || granularities.isEmpty()) {
            granularities = annPage.getItems()[0].isMedia() ? List.copyOf(FTDefinitions.MEDIA_ANNOTATION_TYPES) : List.copyOf(FTDefinitions.TEXT_ANNOTATION_TYPES);
        }
        HashMap<AnnotationType, Boolean> granularityMap = new HashMap<AnnotationType, Boolean>();
        for (AnnotationType annotationType : granularities) {
            granularityMap.put(annotationType, Boolean.FALSE);
        }
        for (AnnotationV3 ann : annPage.getItems()) {
            granularityMap.put(ann.getAnnotationType(), Boolean.TRUE);
            if (!granularityMap.containsValue(Boolean.FALSE)) break;
        }
        for (Map.Entry entry : granularityMap.entrySet()) {
            if (!((Boolean)entry.getValue()).equals(Boolean.TRUE)) continue;
            foundGranularities.add(((AnnotationType)entry.getKey()).getLowerCaseName());
        }
        return foundGranularities.toArray(new String[0]);
    }

    static AnnotationV3 getSingleAnnotationV3(AnnoPage annoPage, String annoId, boolean profileText) {
        Optional<Annotation> maybe = annoPage.getAns().stream().filter(o -> o.getAnId().equals(annoId)).findFirst();
        return maybe.map(annotation1 -> EDM2IIIFMapping.getAnnotationV3(annoPage, annotation1, true, profileText && annotation1.isTopLevel())).orElse(null);
    }

    private static String[] getFTTargetArray(AnnoPage annoPage, Annotation annotation) {
        ArrayList<Object> ftTargetURLList = new ArrayList<Object>();
        if (annotation.getTgs() != null) {
            for (Target target : annotation.getTgs()) {
                ftTargetURLList.add(annoPage.getTgtId() + EDM2IIIFMapping.generateTargetCoordinates(target, annotation.isMedia()));
            }
            return ftTargetURLList.toArray(new String[0]);
        }
        if (annotation.isTopLevel()) {
            ftTargetURLList.add(annoPage.getTgtId());
            return ftTargetURLList.toArray(new String[0]);
        }
        return new String[0];
    }

    private static String generateTargetCoordinates(Target target, boolean isMedia) {
        if (isMedia) {
            return "#t=" + NormalPlayTime.msToHHmmss((long)target.getStart().longValue()) + "," + NormalPlayTime.msToHHmmss((long)target.getEnd().longValue());
        }
        return "#xywh=" + target.getX() + "," + target.getY() + "," + target.getW() + "," + target.getH();
    }

    static FTResource getFTResource(Resource resource) {
        return new FTResource(EDM2IIIFMapping.generateResourceId(resource), resource.getLang(), resource.getValue(), resource.getSource(), resource.getRights());
    }

    private static String generateResourceId(Resource resource) {
        String id = fts.getResourceBaseUrl() + resource.getDsId() + "/" + resource.getLcId() + "/" + resource.getPgId();
        if (resource.isTranslation()) {
            id = id + "?lang=" + resource.getLang();
        }
        return id;
    }

    private static FTResource fetchFTResource(AnnoPage annoPage) {
        FTResource resource;
        try {
            resource = ftService.fetchFTResource(annoPage.getDsId(), annoPage.getLcId(), annoPage.getPgId(), annoPage.getLang());
        }
        catch (ResourceDoesNotExistException e) {
            LOG.info("Error retrieving fulltext resource for annoPage {}", (Object)annoPage, (Object)e);
            resource = null;
        }
        return resource;
    }

    private static String getResourceIdUrl(AnnoPage annoPage, Annotation annotation) {
        StringBuilder s = new StringBuilder(EDM2IIIFMapping.getResourceIdBaseUrl(annoPage));
        if (annotation.getFrom() != null || annotation.getTo() != null) {
            s.append("#char=");
            s.append(annotation.getFrom());
            s.append(",");
            s.append(annotation.getTo());
        }
        return s.toString();
    }

    private static String getResourceIdBaseUrl(AnnoPage annoPage) {
        String url = fts.getResourceBaseUrl() + annoPage.getDsId() + "/" + annoPage.getLcId() + "/";
        url = url + (annoPage.getRes() != null ? annoPage.getRes().getPgId() : annoPage.getPgId());
        if (annoPage.isTranslation()) {
            url = url + "?lang=";
            url = url + (annoPage.getRes() != null ? annoPage.getRes().getLang() : annoPage.getLang());
        }
        return url;
    }

    private static String getAnnoPageIdUrl(AnnoPage annoPage) {
        return fts.getAnnoPageBaseUrl() + annoPage.getDsId() + "/" + annoPage.getLcId() + "/annopage/" + annoPage.getPgId() + "?lang=" + annoPage.getLang();
    }

    private static String getAnnotationIdUrl(AnnoPage annoPage, Annotation annotation) {
        return fts.getAnnotationBaseUrl() + annoPage.getDsId() + "/" + annoPage.getLcId() + "/" + annotation.getAnId();
    }

    public static String getAnnotationIdUrl(String europeanaId, Annotation annotation) {
        StringBuilder s = new StringBuilder(fts.getAnnotationBaseUrl());
        if (europeanaId.startsWith("/")) {
            s.deleteCharAt(s.length() - 1);
        }
        s.append(europeanaId).append("/").append(annotation.getAnId());
        return s.toString();
    }

    private static String dcTypeToTextGranularity(char dcTypeCode) {
        AnnotationType dcType = AnnotationType.fromAbbreviation((char)dcTypeCode);
        if (dcType == null) {
            LOG.warn("Unknown dcType code '{}'", (Object)Character.valueOf(dcTypeCode));
            return "undefined";
        }
        return dcType.getLowerCaseName();
    }

    static {
        LOG = LogManager.getLogger(EDM2IIIFMapping.class);
    }
}

