/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.config;

import eu.europeana.api.commons.definitions.vocabulary.Role;
import eu.europeana.api.commons.nosql.service.ApiWriteLockService;
import eu.europeana.api.commons.oauth2.service.impl.EuropeanaClientDetailsService;
import eu.europeana.api.commons.service.authorization.AuthorizationService;
import eu.europeana.api.commons.service.authorization.BaseAuthorizationService;
import eu.europeana.fulltext.api.config.FTSettings;
import eu.europeana.fulltext.api.web.Roles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.provider.ClientDetailsService;

@Configuration
public class AuthorizationConfig
extends BaseAuthorizationService
implements AuthorizationService {
    private final FTSettings appSettings;
    private final EuropeanaClientDetailsService clientDetailsService;

    @Autowired
    public AuthorizationConfig(FTSettings appSettings, EuropeanaClientDetailsService clientDetailsService) {
        this.appSettings = appSettings;
        this.clientDetailsService = clientDetailsService;
    }

    protected ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    protected String getSignatureKey() {
        return this.appSettings.getApiKeyPublicKey();
    }

    protected String getApiName() {
        return this.appSettings.getAuthorizationApiName();
    }

    protected ApiWriteLockService getApiWriteLockService() {
        return null;
    }

    protected Role getRoleByName(String name) {
        return Roles.getRoleByName(name);
    }
}

