/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.caching;

import eu.europeana.fulltext.api.caching.CachingHeaders;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class CachingUtils
implements CachingHeaders {
    private static final Logger LOG = LogManager.getLogger(CachingUtils.class);
    private static final String ANY = "*";
    private static final String ALLOWED = "GET, HEAD";
    private static final String ALLOWHEADERS = "If-Match, If-None-Match, If-Modified-Since";
    private static final String EXPOSEHEADERS = "Allow, ETag, Last-Modified, Vary";
    private static final String CACHE_CONTROL_VALUE = "public, max-age=";
    private static final String DEFAULT_MAX_AGE = "86400";
    private static final String ACCEPT = "Accept";
    private static final String MAX_AGE_600 = "600";

    private CachingUtils() {
    }

    public static boolean cachingHeadersPresent(HttpServletRequest request) {
        return StringUtils.isNotBlank((CharSequence)request.getHeader("If-Modified-Since")) || StringUtils.isNotBlank((CharSequence)request.getHeader("If-None-Match")) || StringUtils.isNotBlank((CharSequence)request.getHeader("If-Match"));
    }

    public static String generateETag(ZonedDateTime modified, String version, boolean weakETag) {
        String data = CachingUtils.zonedDateTimeToString(modified) + version;
        String eTag = "\"" + CachingUtils.getSHA256Hash(data) + "\"";
        if (weakETag) {
            return "W/" + eTag;
        }
        return eTag;
    }

    public static String zonedDateTimeToString(ZonedDateTime zonedDateTime) {
        return zonedDateTime.format(DateTimeFormatter.RFC_1123_DATE_TIME);
    }

    public static ZonedDateTime dateToZonedUTC(Date date) {
        return date.toInstant().atOffset(ZoneOffset.UTC).toZonedDateTime().withNano(0);
    }

    public static ZonedDateTime januarificator() {
        return ZonedDateTime.of(1990, 1, 11, 0, 0, 0, 0, ZoneId.of("UTC"));
    }

    public static ResponseEntity<String> checkCached(HttpServletRequest request, ZonedDateTime modified, String eTag) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeader("If-None-Match"))) {
            if (CachingUtils.doesAnyETagMatch(request.getHeader("If-None-Match"), eTag)) {
                if (CachingUtils.isReadAccessMethod(request)) {
                    HttpHeaders headers = CachingUtils.generateHeaders(request, eTag, CachingUtils.zonedDateTimeToString(modified));
                    return new ResponseEntity((MultiValueMap)headers, HttpStatus.NOT_MODIFIED);
                }
                return new ResponseEntity(HttpStatus.PRECONDITION_FAILED);
            }
        } else if (StringUtils.isNotBlank((CharSequence)request.getHeader("If-Match"))) {
            if (CachingUtils.doesPreconditionFail(request, eTag)) {
                return new ResponseEntity(HttpStatus.PRECONDITION_FAILED);
            }
        } else if (CachingUtils.isNotModifiedSince(request, modified)) {
            return new ResponseEntity(HttpStatus.NOT_MODIFIED);
        }
        return null;
    }

    private static boolean isReadAccessMethod(HttpServletRequest request) {
        return StringUtils.equalsAny((CharSequence)request.getMethod(), (CharSequence[])new CharSequence[]{HttpMethod.GET.name(), HttpMethod.HEAD.name()});
    }

    public static HttpHeaders generateHeaders(HttpServletRequest request, String eTag, String modified) {
        return CachingUtils.generateHeaders(request, eTag, modified, null);
    }

    public static HttpHeaders generateHeaders(HttpServletRequest request, String eTag, String modified, Integer maxAge) {
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.isNotBlank((CharSequence)request.getHeader("Origin"))) {
            headers.add("Access-Control-Allow-Methods", ALLOWED);
            headers.add("Access-Control-Allow-Headers", ALLOWHEADERS);
            headers.add("Access-Control-Expose-Headers", EXPOSEHEADERS);
        }
        if (StringUtils.isNotBlank((CharSequence)eTag)) {
            headers.add("ETag", eTag);
        }
        if (StringUtils.isNotBlank((CharSequence)modified)) {
            headers.add("Last-Modified", modified);
        }
        headers.add("Access-Control-Max-Age", MAX_AGE_600);
        headers.add("Allow", ALLOWED);
        headers.add("Cache-Control", CACHE_CONTROL_VALUE + (Serializable)(maxAge == null ? DEFAULT_MAX_AGE : maxAge));
        headers.add("Vary", ACCEPT);
        return headers;
    }

    private static boolean doesAnyIfNoneMatch(HttpServletRequest request, String eTag) {
        return StringUtils.isNotBlank((CharSequence)request.getHeader("If-None-Match")) && CachingUtils.doesAnyETagMatch(request.getHeader("If-None-Match"), eTag);
    }

    private static boolean isNotModifiedSince(HttpServletRequest request, ZonedDateTime modified) {
        return StringUtils.isNotBlank((CharSequence)request.getHeader("If-Modified-Since")) && Objects.requireNonNull(CachingUtils.stringToZonedUTC(request.getHeader("If-Modified-Since"))).compareTo(modified) >= 0;
    }

    private static boolean doesPreconditionFail(HttpServletRequest request, String eTag) {
        return StringUtils.isNotBlank((CharSequence)request.getHeader("If-Match")) && !CachingUtils.doesAnyETagMatch(request.getHeader("If-Match"), eTag);
    }

    private static boolean doesAnyETagMatch(String eTags, String eTagToMatch) {
        if (StringUtils.equals((CharSequence)ANY, (CharSequence)eTags)) {
            return true;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{eTags, eTagToMatch})) {
            for (String eTag : StringUtils.stripAll((String[])StringUtils.split((String)eTags, (String)","))) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)CachingUtils.spicAndSpan(eTag), (CharSequence)CachingUtils.spicAndSpan(eTagToMatch))) continue;
                return true;
            }
        }
        return false;
    }

    private static String spicAndSpan(String header) {
        return StringUtils.remove((String)StringUtils.stripStart((String)header, (String)"W/"), (String)"\"");
    }

    private static String getSHA256Hash(String data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedhash = digest.digest(data.getBytes(StandardCharsets.UTF_8));
            return CachingUtils.bytesToHex(encodedhash);
        }
        catch (NoSuchAlgorithmException e) {
            LogManager.getLogger(CachingUtils.class).error("Error generating SHA-265 hash from record timestamp_update", (Throwable)e);
            return null;
        }
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder();
        for (byte bt : hash) {
            String hex = Integer.toHexString(0xFF & bt);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private static ZonedDateTime stringToZonedUTC(String dateString) {
        if (StringUtils.isEmpty((CharSequence)dateString)) {
            return null;
        }
        Date date = DateUtils.parseDate((String)dateString);
        if (date == null) {
            LOG.error("Error parsing request header Date string: {}", (Object)dateString);
            return null;
        }
        return CachingUtils.dateToZonedUTC(date);
    }

    public static void updateCorsExposeHeader(HttpServletRequest request, HttpHeaders headers) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeader("Origin"))) {
            headers.add("Access-Control-Expose-Headers", "Vary");
        }
    }
}

