/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.search.config;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.solr.core.SolrTemplate;
import org.springframework.data.solr.repository.config.EnableSolrRepositories;

@Configuration
@EnableSolrRepositories(basePackages={"eu.europeana.fulltext.search.repository"})
public class SearchConfig {
    public static final int MAXIMUM_HITS = 100;
    public static final int QUERY_TIME_ALLOWED = 30000;
    public static final String HIT_TAG_START = "";
    public static final String HIT_TAG_END = "";
    public static final int HIT_MERGE_MAX_DISTANCE = 3;
    @Value(value="${spring.data.solr.zk-host:}")
    private String zookeeperHosts;
    @Value(value="${spring.data.solr.host:}")
    private String solrHost;
    @Value(value="${spring.data.solr.core:}")
    private String solrCore;
    @Value(value="${spring.data.solr.hl.maxAnalyzedChars:}")
    private Integer hlMaxAnalyzeChars;

    @Bean
    public SolrClient solrClient() {
        if (this.zookeeperHosts.isBlank() || this.zookeeperHosts.toUpperCase(Locale.GERMAN).contains("REMOVED")) {
            LogManager.getLogger(SearchConfig.class).info("No zookeeper configured, trying to connect to standalone server");
            return new HttpSolrClient.Builder(this.solrHost).build();
        }
        List<String> zkHosts = Arrays.asList(this.zookeeperHosts.split(","));
        CloudSolrClient client = new CloudSolrClient.Builder(zkHosts, Optional.empty()).build();
        client.setDefaultCollection(this.solrCore);
        return client;
    }

    @Bean
    public SolrTemplate solrTemplate(SolrClient solrClient) {
        return new SolrTemplate(solrClient);
    }
}

