/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.web;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.api.commons.service.authorization.AuthorizationService;
import eu.europeana.api.commons.web.controller.BaseRestController;
import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.api.commons.web.service.AbstractRequestPathMethodService;
import eu.europeana.fulltext.api.config.FTSettings;
import eu.europeana.fulltext.api.model.v2.AnnotationPageV2;
import eu.europeana.fulltext.api.service.CacheUtils;
import eu.europeana.fulltext.api.service.FTService;
import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.exception.AnnoPageDoesNotExistException;
import eu.europeana.fulltext.exception.AnnoPageGoneException;
import eu.europeana.fulltext.exception.InvalidUriException;
import eu.europeana.fulltext.exception.MediaTypeNotSupportedException;
import eu.europeana.fulltext.exception.SerializationException;
import eu.europeana.fulltext.exception.UnsupportedAnnotationException;
import eu.europeana.fulltext.service.AnnotationApiRestService;
import eu.europeana.fulltext.subtitles.AnnotationPreview;
import eu.europeana.fulltext.subtitles.DeleteAnnoSyncResponse;
import eu.europeana.fulltext.subtitles.FulltextType;
import eu.europeana.fulltext.subtitles.external.AnnotationItem;
import eu.europeana.fulltext.util.AnnotationUtils;
import eu.europeana.fulltext.util.GeneralUtils;
import eu.europeana.fulltext.util.RequestUtils;
import eu.europeana.iiif.AcceptUtils;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@Validated
public class FTWriteController
extends BaseRestController {
    private final FTSettings appSettings;
    private final AnnotationApiRestService annotationsApiRestService;
    private final FTService ftService;
    private final Predicate<String> annotationIdPattern;
    private final AuthorizationService ftAuthorizationService;
    private final AbstractRequestPathMethodService requestPathMethodService;
    private static final Logger LOG = LogManager.getLogger(FTWriteController.class);

    public FTWriteController(FTSettings appSettings, AnnotationApiRestService annotationsApiRestService, FTService ftService, AuthorizationService ftAuthorizationService, AbstractRequestPathMethodService requestPathMethodService) {
        this.appSettings = appSettings;
        this.annotationsApiRestService = annotationsApiRestService;
        this.ftService = ftService;
        this.annotationIdPattern = Pattern.compile(String.format("https?://%s/annotation/\\d+", appSettings.getAnnotationIdHostsPattern())).asMatchPredicate();
        this.ftAuthorizationService = ftAuthorizationService;
        this.requestPathMethodService = requestPathMethodService;
    }

    protected AuthorizationService getAuthorizationService() {
        return this.ftAuthorizationService;
    }

    @Tag(name="Synchronize annotations", description="Propagate and synchronise with Annotations API")
    @PostMapping(value={"/fulltext/annosync"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> syncAnnotations(@RequestParam(value="source") String source, HttpServletRequest request, @RequestParam(value="profile", required=false) String profileParam) throws ApplicationAuthenticationException, EuropeanaApiException {
        if (this.appSettings.isAuthEnabled()) {
            this.verifyWriteAccess("update", request);
        }
        List<String> profiles = RequestUtils.extractProfiles(profileParam);
        if (!GeneralUtils.isValidAnnotationId((String)source, this.annotationIdPattern)) {
            throw new InvalidUriException(String.format("'%s' request parameter must be a valid annotation id", "source"));
        }
        Optional itemOptional = this.annotationsApiRestService.retrieveAnnotation(source);
        if (itemOptional.isEmpty()) {
            DeleteAnnoSyncResponse response;
            AnnoPage annoPage = this.ftService.getShellAnnoPageBySource(source, false);
            if (annoPage == null) {
                response = new DeleteAnnoSyncResponse(source, DeleteAnnoSyncResponse.Status.NOOP.getValue(), null);
            } else {
                this.ftService.deprecateAnnoPagesWithSources(Collections.singletonList(source));
                response = new DeleteAnnoSyncResponse(source, DeleteAnnoSyncResponse.Status.DELETED.getValue(), annoPage);
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.ACCEPTED).header("Allow", new String[]{this.getMethodsForRequestPattern(request, this.requestPathMethodService)})).body((Object)this.ftService.serialise(response));
        }
        AnnotationItem item = (AnnotationItem)itemOptional.get();
        String motivation = item.getMotivation();
        if (!"subtitling".equals(motivation) && !"transcribing".equals(motivation)) {
            throw new UnsupportedAnnotationException(String.format("Annotation motivation '%s' not supported for sync. Only subtitles or transcribing are supported", motivation));
        }
        AnnotationPreview annotationPreview = AnnotationUtils.createAnnotationPreview((AnnotationItem)item);
        AnnoPage annoPage = this.ftService.createAnnoPage(annotationPreview, true);
        this.ftService.upsertAnnoPage(List.of(annoPage));
        return this.generateResponse(request, annoPage, profiles, HttpStatus.ACCEPTED);
    }

    @Tag(name="Submit new fulltext", description="Submits a new fulltext document for a given Europeana ID (dataset + localID)")
    @PostMapping(value={"/presentation/{datasetId}/{localId}/annopage"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> submitNewFulltext(@PathVariable(value="datasetId") String datasetId, @PathVariable(value="localId") String localId, @RequestParam(value="media") String media, @RequestParam(value="lang") String lang, @RequestParam(value="originalLang", required=false, defaultValue="false") boolean originalLang, @RequestParam(value="rights") String rights, @RequestParam(value="source", required=false) String source, @RequestParam(value="profile", required=false) String profileParam, @RequestBody String content, HttpServletRequest request) throws ApplicationAuthenticationException, EuropeanaApiException {
        if (this.appSettings.isAuthEnabled()) {
            this.verifyWriteAccess("create", request);
        }
        List<String> profiles = RequestUtils.extractProfiles(profileParam);
        String pageId = GeneralUtils.derivePageId((String)media);
        AnnoPage existingAnnoPage = this.ftService.getShellAnnoPageById(datasetId, localId, pageId, lang, true);
        if (existingAnnoPage != null && !existingAnnoPage.isDeprecated()) {
            String redirectPath = String.format("/presentation/%s/%s/annopage/%s", datasetId, localId, pageId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("AnnoPage already exists for subtitle. Redirecting to {}?lang={}", (Object)redirectPath, (Object)lang);
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.MOVED_PERMANENTLY).location(UriComponentsBuilder.newInstance().path(redirectPath).query("lang=" + lang).build().toUri())).build();
        }
        FulltextType type = FulltextType.getValueByMimetype((String)request.getContentType());
        if (type == null) {
            throw new MediaTypeNotSupportedException("The content type " + request.getContentType() + " is not supported");
        }
        AnnotationPreview annotationPreview = AnnotationUtils.createAnnotationPreview((String)datasetId, (String)localId, (String)lang, (boolean)originalLang, (String)rights, (String)source, (String)media, (String)content, (FulltextType)type);
        AnnoPage createdAnnoPage = this.ftService.createAnnoPage(annotationPreview, false);
        createdAnnoPage.copyDbIdFrom(existingAnnoPage);
        this.ftService.upsertAnnoPage(List.of(createdAnnoPage));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new AnnoPage {}", (Object)createdAnnoPage);
        }
        return this.generateResponse(request, createdAnnoPage, profiles, HttpStatus.OK);
    }

    @Tag(name="Replace fulltext", description="Replaces existing fulltext for a media resource with a new document")
    @PutMapping(value={"/presentation/{datasetId}/{localId}/annopage/{pageId}"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> replaceFullText(@PathVariable(value="datasetId") String datasetId, @PathVariable(value="localId") String localId, @PathVariable(value="pageId") String pageId, @RequestParam(value="lang") String lang, @RequestParam(value="originalLang", required=false, defaultValue="false") boolean originalLang, @RequestParam(value="rights") String rights, @RequestParam(value="source", required=false) String source, @RequestParam(value="profile", required=false) String profileParam, @RequestBody(required=false) String content, HttpServletRequest request) throws ApplicationAuthenticationException, EuropeanaApiException {
        if (this.appSettings.isAuthEnabled()) {
            this.verifyWriteAccess("update", request);
        }
        List<String> profiles = RequestUtils.extractProfiles(profileParam);
        AnnoPage annoPage = this.ftService.getAnnoPageByPgId(datasetId, localId, pageId, lang, true);
        if (annoPage == null) {
            throw new AnnoPageDoesNotExistException("Annotation page does not exist for " + GeneralUtils.getAnnoPageUrl((String)datasetId, (String)localId, (String)pageId, (String)lang));
        }
        if (annoPage.isDeprecated() && StringUtils.isEmpty((CharSequence)content)) {
            throw new AnnoPageGoneException(String.format("/%s/%s/annopage/%s", datasetId, localId, pageId), lang, "Send content to update the deprecated Annopage");
        }
        FulltextType type = null;
        if (!StringUtils.isEmpty((CharSequence)content) && (type = FulltextType.getValueByMimetype((String)request.getContentType())) == null) {
            throw new MediaTypeNotSupportedException("The content type " + request.getContentType() + " is not supported");
        }
        AnnotationPreview annotationPreview = AnnotationUtils.createAnnotationPreview((String)datasetId, (String)localId, (String)lang, (boolean)originalLang, (String)rights, (String)source, (String)annoPage.getTgtId(), (String)content, (FulltextType)type);
        AnnoPage updatedAnnoPage = this.ftService.updateAnnoPage(annotationPreview, annoPage);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Replaced AnnoPage {}", (Object)updatedAnnoPage);
        }
        return this.generateResponse(request, updatedAnnoPage, profiles, HttpStatus.OK);
    }

    @Tag(name="Deprecate fulltext", description="Deprecates the full-text associated to a media resource\n")
    @DeleteMapping(value={"/presentation/{datasetId}/{localId}/annopage/{pageId}"}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> deprecateFulltext(@PathVariable(value="datasetId") String datasetId, @PathVariable(value="localId") String localId, @PathVariable(value="pageId") String pageId, @RequestParam(value="lang", required=false) String lang, HttpServletRequest request) throws ApplicationAuthenticationException, EuropeanaApiException {
        if (this.appSettings.isAuthEnabled()) {
            this.verifyWriteAccess("delete", request);
        }
        this.ftService.checkForExistingAndDeprecatedAnnoPages(datasetId, localId, pageId, lang, true);
        if (StringUtils.isNotEmpty((CharSequence)lang)) {
            this.ftService.deprecateAnnoPages(datasetId, localId, pageId, lang);
        } else {
            this.ftService.deprecateAnnoPages(datasetId, localId, pageId);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deprecated AnnoPage(s) for {}/{}/{}?lang={}", (Object)datasetId, (Object)localId, (Object)pageId, (Object)lang);
        }
        return this.noContentResponse(request);
    }

    protected ResponseEntity<String> generateResponse(HttpServletRequest request, AnnoPage annoPage, List<String> profiles, HttpStatus status) throws SerializationException {
        AnnotationPageV2 annotationWrapper = this.ftService.generateAnnoPageV2(annoPage, null, profiles.contains("text"));
        ZonedDateTime modified = CacheUtils.dateToZonedUTC(annoPage.getModified());
        String requestVersion = "2";
        String eTag = CacheUtils.generateETag(annoPage.getDsId() + annoPage.getLcId() + annoPage.getPgId(), modified, requestVersion + this.appSettings.getAppVersion(), true);
        HttpHeaders headers = CacheUtils.generateHeaders(request, eTag, CacheUtils.zonedDateTimeToString(modified));
        AcceptUtils.addContentTypeToResponseHeader((HttpHeaders)headers, (String)requestVersion, (boolean)false);
        headers.set("Allow", this.getMethodsForRequestPattern(request, this.requestPathMethodService));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)status).headers(headers)).body((Object)this.ftService.serialise(annotationWrapper));
    }

    private ResponseEntity<String> noContentResponse(HttpServletRequest request) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Allow", this.getMethodsForRequestPattern(request, this.requestPathMethodService));
        AcceptUtils.addContentTypeToResponseHeader((HttpHeaders)headers, (String)"2", (boolean)false);
        return ResponseEntity.noContent().headers(headers).build();
    }
}

