/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.result.UpdateResult;
import dev.morphia.query.internal.MorphiaCursor;
import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.fulltext.AnnotationType;
import eu.europeana.fulltext.api.config.FTSettings;
import eu.europeana.fulltext.api.model.FTResource;
import eu.europeana.fulltext.api.model.info.SummaryAnnoPage;
import eu.europeana.fulltext.api.model.info.SummaryCanvas;
import eu.europeana.fulltext.api.model.info.SummaryManifest;
import eu.europeana.fulltext.api.model.v2.AnnotationPageV2;
import eu.europeana.fulltext.api.model.v2.AnnotationV2;
import eu.europeana.fulltext.api.model.v3.AnnotationPageV3;
import eu.europeana.fulltext.api.model.v3.AnnotationV3;
import eu.europeana.fulltext.api.service.EDM2IIIFMapping;
import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.entity.Resource;
import eu.europeana.fulltext.exception.AnnoPageDoesNotExistException;
import eu.europeana.fulltext.exception.AnnoPageGoneException;
import eu.europeana.fulltext.exception.ResourceDoesNotExistException;
import eu.europeana.fulltext.exception.SerializationException;
import eu.europeana.fulltext.repository.AnnoPageRepository;
import eu.europeana.fulltext.repository.ResourceRepository;
import eu.europeana.fulltext.service.CommonFTService;
import eu.europeana.fulltext.subtitles.AnnotationPreview;
import eu.europeana.fulltext.util.AnnotationUtils;
import eu.europeana.fulltext.util.GeneralUtils;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FTService
extends CommonFTService {
    private static final String GENERATED_IN = "Generated in {} ms ";
    private static final String ANNOPAGE_ID_FORMAT = "/%s/%s/annopage/%s";
    private static final String ANNOPAGE_ID_LANG_FORMAT = "/%s/%s/annopage/%s";
    private static final Logger LOG = LogManager.getLogger(FTService.class);
    private final FTSettings ftSettings;
    private final ObjectMapper mapper;
    @Value(value="${spring.profiles.active:}")
    private String activeProfileString;

    public FTService(ResourceRepository resourceRepository, AnnoPageRepository annoPageRepository, FTSettings ftSettings, ObjectMapper mapper) {
        super(resourceRepository, annoPageRepository);
        this.ftSettings = ftSettings;
        this.mapper = mapper;
    }

    public FTSettings getSettings() {
        return this.ftSettings;
    }

    public AnnoPage fetchAnnoPage(String datasetId, String localId, String pageId, List<AnnotationType> textGranValues, String lang) throws AnnoPageDoesNotExistException, AnnoPageGoneException {
        AnnoPage result;
        if (StringUtils.isEmpty((CharSequence)lang)) {
            result = this.annoPageRepository.findOriginalByPageId(datasetId, localId, pageId, textGranValues, false);
            if (result == null) {
                throw new AnnoPageDoesNotExistException(String.format("/%s/%s/annopage/%s", datasetId, localId, pageId));
            }
        } else {
            result = this.annoPageRepository.findByPageIdLang(datasetId, localId, pageId, textGranValues, lang, true);
            if (result == null) {
                throw new AnnoPageDoesNotExistException(String.format("/%s/%s/annopage/%s", datasetId, localId, pageId), lang);
            }
            if (result.isDeprecated()) {
                throw new AnnoPageGoneException(String.format("/%s/%s/annopage/%s", datasetId, localId, pageId), lang);
            }
        }
        return result;
    }

    public MorphiaCursor<AnnoPage> fetchAnnoPageFromTargetId(String datasetId, String localId, List<String> targetIds, List<AnnotationType> annoTypes, boolean includeDeprecated) {
        return this.annoPageRepository.findByTargetId(datasetId, localId, targetIds, annoTypes, includeDeprecated);
    }

    public AnnoPage fetchAPAnnotation(String datasetId, String localId, String annoId) throws EuropeanaApiException {
        AnnoPage result = this.annoPageRepository.findByAnnoId(datasetId, localId, annoId, true);
        if (result == null) {
            throw new AnnoPageDoesNotExistException(String.format("/%s/%s/anno/%s", datasetId, localId, annoId));
        }
        if (result.isDeprecated()) {
            throw new AnnoPageGoneException(String.format("/%s/%s/anno/%s", datasetId, localId, annoId));
        }
        return result;
    }

    public FTResource fetchFTResource(String datasetId, String localId, String pageId, String lang) throws ResourceDoesNotExistException {
        Resource result;
        if (StringUtils.isEmpty((CharSequence)lang)) {
            result = this.resourceRepository.findOriginalByPageId(datasetId, localId, pageId);
            if (result == null) {
                throw new ResourceDoesNotExistException(String.format("/%s/%s/%s", datasetId, localId, pageId));
            }
        } else {
            result = this.resourceRepository.findByPageIdLang(datasetId, localId, pageId, lang);
            if (result == null) {
                throw new ResourceDoesNotExistException(String.format("/%s/%s/%s?lang=%s", datasetId, localId, pageId, lang));
            }
        }
        return this.generateFTResource(result);
    }

    public AnnoPage getSingleAnnoPage(String datasetId, String localId) throws AnnoPageDoesNotExistException {
        AnnoPage annoPage = this.annoPageRepository.findPage(datasetId, localId);
        if (annoPage == null) {
            throw new AnnoPageDoesNotExistException(datasetId + "/" + localId);
        }
        return annoPage;
    }

    public SummaryManifest collectionAnnoPageInfo(String datasetId, String localId) {
        Instant start = Instant.now();
        SummaryManifest apInfoSummaryManifest = new SummaryManifest(datasetId, localId);
        List annoPages = this.annoPageRepository.getAnnoPages(datasetId, localId, null, false, true);
        Instant finish = Instant.now();
        LOG.debug("Time taken to fetch all the annoPages for {}/{} is - {}", (Object)datasetId, (Object)localId, (Object)Duration.between(start, finish).toMillis());
        LinkedHashMap<String, List> annoPerPage = new LinkedHashMap<String, List>();
        for (AnnoPage annoPage : annoPages) {
            annoPerPage.computeIfAbsent(annoPage.getPgId(), k -> new ArrayList()).add(annoPage);
        }
        for (Map.Entry entry : annoPerPage.entrySet()) {
            SummaryCanvas summaryCanvas = new SummaryCanvas(this.makeSummaryCanvasID(datasetId, localId, (String)entry.getKey()));
            Optional<AnnoPage> originalAnnoPage = ((List)entry.getValue()).stream().filter(annopage -> !annopage.isTranslation()).findFirst();
            if (originalAnnoPage.isPresent()) {
                summaryCanvas.setOriginalLanguage(originalAnnoPage.get().getLang());
            }
            for (AnnoPage annoPage : (List)entry.getValue()) {
                summaryCanvas.addAnnotation(new SummaryAnnoPage(this.makeLangAwareAnnoPageID(datasetId, localId, annoPage.getPgId(), annoPage.getLang()), annoPage.getLang(), EDM2IIIFMapping.getTextGranularitiesForSummary(annoPage), annoPage.getSource()));
            }
            apInfoSummaryManifest.addCanvas(summaryCanvas);
        }
        return apInfoSummaryManifest;
    }

    @Deprecated
    private String makeSummaryCanvasID(AnnoPage ap) {
        return this.ftSettings.getAnnoPageBaseUrl() + ap.getDsId() + "/" + ap.getLcId() + "/canvas/" + ap.getPgId();
    }

    private String makeSummaryCanvasID(String dsId, String lcId, String pgId) {
        return this.ftSettings.getAnnoPageBaseUrl() + dsId + "/" + lcId + "/canvas/" + pgId;
    }

    @Deprecated
    private String makeLangAwareAnnoPageID(AnnoPage ap) {
        StringBuilder result = new StringBuilder(100);
        result.append(this.ftSettings.getAnnoPageBaseUrl()).append(ap.getDsId()).append("/").append(ap.getLcId()).append("/annopage").append("/").append(ap.getPgId());
        if (!StringUtils.isEmpty((CharSequence)ap.getLang())) {
            result.append("?").append("lang=").append(ap.getLang());
        }
        return result.toString();
    }

    private String makeLangAwareAnnoPageID(String dsId, String lcId, String pgId, String lang) {
        StringBuilder result = new StringBuilder(100);
        result.append(this.ftSettings.getAnnoPageBaseUrl()).append(dsId).append("/").append(lcId).append("/annopage").append("/").append(pgId);
        if (!StringUtils.isEmpty((CharSequence)lang)) {
            result.append("?").append("lang=").append(lang);
        }
        return result.toString();
    }

    public boolean doesAnnoPageExist(String datasetId, String localId, String pageId, String lang, boolean includeDeprecated) {
        if (StringUtils.isEmpty((CharSequence)lang)) {
            return this.annoPageRepository.existsOriginalByPageId(datasetId, localId, pageId, includeDeprecated);
        }
        return this.annoPageRepository.existsByPageIdLang(datasetId, localId, pageId, lang, includeDeprecated);
    }

    public AnnotationPageV3 generateAnnoPageV3(AnnoPage annoPage, List<AnnotationType> textGranValues, boolean derefResource) {
        long start = System.currentTimeMillis();
        AnnotationPageV3 result = EDM2IIIFMapping.getAnnotationPageV3(annoPage, textGranValues, derefResource);
        if (LOG.isDebugEnabled()) {
            LOG.debug(GENERATED_IN, (Object)(System.currentTimeMillis() - start));
        }
        return result;
    }

    public AnnotationPageV2 generateAnnoPageV2(AnnoPage annoPage, List<AnnotationType> textGranValues, boolean derefResource) {
        long start = System.currentTimeMillis();
        AnnotationPageV2 result = EDM2IIIFMapping.getAnnotationPageV2(annoPage, textGranValues, derefResource);
        if (LOG.isDebugEnabled()) {
            LOG.debug(GENERATED_IN, (Object)(System.currentTimeMillis() - start));
        }
        return result;
    }

    public AnnotationV3 generateAnnotationV3(AnnoPage annoPage, String annoId) {
        long start = System.currentTimeMillis();
        AnnotationV3 result = EDM2IIIFMapping.getSingleAnnotationV3(annoPage, annoId);
        if (LOG.isDebugEnabled()) {
            LOG.debug(GENERATED_IN, (Object)(System.currentTimeMillis() - start));
        }
        return result;
    }

    public AnnotationV2 generateAnnotationV2(AnnoPage annoPage, String annoId) {
        long start = System.currentTimeMillis();
        AnnotationV2 result = EDM2IIIFMapping.getSingleAnnotationV2(annoPage, annoId);
        if (LOG.isDebugEnabled()) {
            LOG.debug(GENERATED_IN, (Object)(System.currentTimeMillis() - start));
        }
        return result;
    }

    private FTResource generateFTResource(Resource resource) {
        long start = System.currentTimeMillis();
        FTResource result = EDM2IIIFMapping.getFTResource(resource);
        if (LOG.isDebugEnabled()) {
            LOG.debug(GENERATED_IN, (Object)(System.currentTimeMillis() - start));
        }
        return result;
    }

    public AnnoPage updateAnnoPage(AnnotationPreview annotationPreview, AnnoPage existingAnnoPage) throws EuropeanaApiException {
        AnnoPage annoPage = this.getAnnoPageToUpdate(annotationPreview, existingAnnoPage);
        this.resourceRepository.saveResource(annoPage.getRes());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated Resource in db : id={}", (Object)annoPage.getRes().getId());
        }
        if (AnnotationUtils.isAnnoPageUpdateRequired((AnnotationPreview)annotationPreview)) {
            UpdateResult results = this.annoPageRepository.updateAnnoPage(existingAnnoPage, annoPage);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated annoPage in db : dsId={}, lcId={}, pgId={}, lang={}, matched={}, modified={}", (Object)annoPage.getDsId(), (Object)annoPage.getLcId(), (Object)annoPage.getPgId(), (Object)annoPage.getLang(), (Object)results.getMatchedCount(), (Object)results.getModifiedCount());
            }
        }
        return annoPage;
    }

    private AnnoPage getAnnoPageToUpdate(AnnotationPreview annotationPreview, AnnoPage existingAnnoPage) throws EuropeanaApiException {
        AnnoPage annoPageTobeUpdated = null;
        if (StringUtils.isEmpty((CharSequence)annotationPreview.getAnnotationBody())) {
            annoPageTobeUpdated = existingAnnoPage;
            annoPageTobeUpdated.getRes().setRights(annotationPreview.getRights());
            if (StringUtils.isNotEmpty((CharSequence)annotationPreview.getSource())) {
                annoPageTobeUpdated.setSource(annotationPreview.getSource());
            }
        } else {
            annoPageTobeUpdated = this.createAnnoPage(annotationPreview, false);
            if (StringUtils.isEmpty((CharSequence)annoPageTobeUpdated.getSource()) && StringUtils.isNotEmpty((CharSequence)existingAnnoPage.getSource())) {
                annoPageTobeUpdated.setSource(existingAnnoPage.getSource());
            }
        }
        return annoPageTobeUpdated;
    }

    public void checkForExistingAndDeprecatedAnnoPages(String datasetId, String localId, String pageId, String lang, boolean includeDeprecated) throws AnnoPageDoesNotExistException, AnnoPageGoneException {
        if (lang != null) {
            AnnoPage annoPage2 = this.getShellAnnoPageById(datasetId, localId, pageId, lang, includeDeprecated);
            if (annoPage2 == null) {
                throw new AnnoPageDoesNotExistException(GeneralUtils.getAnnoPageUrl((String)datasetId, (String)localId, (String)pageId, (String)lang));
            }
            if (annoPage2.isDeprecated()) {
                throw new AnnoPageGoneException(String.format("/%s/%s/annopage/%s", datasetId, localId, pageId), lang);
            }
        } else {
            List<AnnoPage> existingAnnoPages = this.getAnnoPages(datasetId, localId, pageId, includeDeprecated);
            if (existingAnnoPages.isEmpty()) {
                throw new AnnoPageDoesNotExistException(GeneralUtils.getAnnoPageUrl((String)datasetId, (String)localId, (String)pageId, (String)lang));
            }
            boolean isAllDeprecated = existingAnnoPages.stream().allMatch(annoPage -> annoPage.isDeprecated());
            if (isAllDeprecated) {
                throw new AnnoPageGoneException(String.format("/%s/%s/annopage/%s", datasetId, localId, pageId));
            }
        }
    }

    public AnnoPage getShellAnnoPageBySource(String source, boolean includeDeprecated) {
        return this.annoPageRepository.getAnnoPageWithSource(source, false, includeDeprecated);
    }

    public AnnoPage getShellAnnoPageById(String datasetId, String localId, String pageId, String lang, boolean includeDeprecated) {
        return this.annoPageRepository.getShellAnnoPageById(datasetId, localId, pageId, lang, includeDeprecated);
    }

    public List<AnnoPage> getAnnoPages(String datasetId, String localId, String pageId, boolean includeDeprecated) {
        return this.annoPageRepository.getAnnoPages(datasetId, localId, pageId, includeDeprecated, false);
    }

    public String serialise(Object data) throws SerializationException {
        try {
            return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(data);
        }
        catch (IOException e) {
            throw new SerializationException("Error serialising data: " + e.getMessage(), e);
        }
    }

    public AnnoPage getAnnoPageByPgId(String datasetId, String localId, String pgId, String lang, boolean includeDeprecated) {
        return this.annoPageRepository.findByPageIdLang(datasetId, localId, pgId, List.of(), lang, includeDeprecated);
    }

    public void dropCollections() {
        this.annoPageRepository.deleteAll();
        this.resourceRepository.deleteAll();
    }

    public long countAnnoPage() {
        if (GeneralUtils.testProfileNotActive((String)this.activeProfileString)) {
            LOG.warn("Repository count is temporarily disabled because of bad performance with large collections");
            return 0L;
        }
        return this.annoPageRepository.count();
    }

    public long countResource() {
        if (GeneralUtils.testProfileNotActive((String)this.activeProfileString)) {
            LOG.warn("Repository count is temporarily disabled because of bad performance with large collections");
            return 0L;
        }
        return this.resourceRepository.count();
    }

    public boolean resourceExists(String datasetId, String localId, String pageId, String lang) {
        return this.resourceRepository.resourceExists(datasetId, localId, pageId, lang);
    }

    public void deleteAll() {
        if (GeneralUtils.testProfileNotActive((String)this.activeProfileString)) {
            LOG.warn("Attempting to delete repository from non-test code...");
            return;
        }
        this.annoPageRepository.deleteAll();
        this.resourceRepository.deleteAll();
    }
}

