/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.search.repository;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.fulltext.search.model.query.EuropeanaId;
import eu.europeana.fulltext.search.model.response.Debug;
import eu.europeana.fulltext.search.repository.SolrHighlightQuery;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.solr.core.SolrTemplate;

public class SolrHighlightQueryImpl
implements SolrHighlightQuery {
    private static final Logger LOG = LogManager.getLogger(SolrHighlightQueryImpl.class);
    private static final String HL_QUERY = "hl.q";
    private static final String HL_FIELDS = "hl.fl";
    private static final String HL_EXTENDED_PARAM = "hl.extended";
    private static final String HL_METHOD_PARAM = "hl.method";
    private static final String HL_MAXANALYZEDCHARS_PARAM = "hl.maxAnalyzedChars";
    private static final String EUROPEANA_ID_FIELD = "europeana_id";
    @Autowired
    private SolrTemplate solrTemplate;
    @Value(value="${spring.data.solr.core:}")
    private String solrCore;
    @Value(value="${spring.data.solr.hl.maxAnalyzedChars:}")
    private Integer maxAnalyzedChars;

    @Override
    public Map<String, List<String>> getHighlightsWithOffsets(EuropeanaId europeanaId, String query, int maxSnippets, Debug debug) throws EuropeanaApiException {
        QueryResponse response;
        SolrQuery q = this.createQuery(europeanaId, query, maxSnippets);
        if (debug != null) {
            debug.setSolrQuery(q.toQueryString());
        }
        try {
            response = this.solrTemplate.getSolrClient().query(this.solrCore, (SolrParams)this.createQuery(europeanaId, query, maxSnippets));
            if (LOG.isTraceEnabled()) {
                LOG.trace("Solr response = {}", (Object)response.jsonStr());
            }
        }
        catch (IOException | SolrServerException e) {
            throw new EuropeanaApiException("Error querying Solr", e);
        }
        SolrDocumentList list = response.getResults();
        if (list.getNumFound() == 0L) {
            return null;
        }
        Map highlights = response.getHighlighting();
        return (Map)highlights.get(europeanaId.toString());
    }

    SolrQuery createQuery(EuropeanaId europeanaId, String query, int maxSnippets) {
        SolrQuery sq = new SolrQuery();
        sq.setQuery("europeana_id:" + ClientUtils.escapeQueryChars((String)europeanaId.toString()));
        sq.setRows(Integer.valueOf(1));
        sq.setTimeAllowed(Integer.valueOf(30000));
        sq.setFields(new String[]{EUROPEANA_ID_FIELD});
        sq.setHighlight(true).setHighlightSnippets(maxSnippets).setHighlightFragsize(0).setHighlightSimplePre("").setHighlightSimplePost("").set(HL_EXTENDED_PARAM, new String[]{"true"}).set(HL_METHOD_PARAM, new String[]{"unified"}).set(HL_QUERY, new String[]{ClientUtils.escapeQueryChars((String)query)}).set(HL_FIELDS, new String[]{"fulltext.*"});
        if (this.maxAnalyzedChars != null) {
            sq.set(HL_MAXANALYZEDCHARS_PARAM, new String[]{String.valueOf(this.maxAnalyzedChars)});
        }
        return sq;
    }
}

