/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.web;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.fulltext.AnnotationType;
import eu.europeana.fulltext.api.config.FTDefinitions;
import eu.europeana.fulltext.api.model.AnnotationWrapper;
import eu.europeana.fulltext.api.model.FTResource;
import eu.europeana.fulltext.api.model.info.SummaryManifest;
import eu.europeana.fulltext.api.service.CacheUtils;
import eu.europeana.fulltext.api.service.ControllerUtils;
import eu.europeana.fulltext.api.service.FTService;
import eu.europeana.fulltext.api.service.exception.InvalidVersionException;
import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.util.RequestUtils;
import eu.europeana.iiif.AcceptUtils;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Full-text item", description="Retrieve a page with annotations, an individual annotation or a full-text")
public class FTRetrievalController {
    private static final Set<AnnotationType> ALLOWED_ANNOTATION_TYPES = EnumSet.of(AnnotationType.PAGE, new AnnotationType[]{AnnotationType.BLOCK, AnnotationType.LINE, AnnotationType.WORD, AnnotationType.MEDIA, AnnotationType.CAPTION});
    private static final Logger LOG = LogManager.getLogger(FTRetrievalController.class);
    private final FTService fts;

    public FTRetrievalController(FTService ftService) {
        this.fts = ftService;
    }

    @Tag(name="All Annopages (JSON)", description="Lists available Annotation Pages for a given EuropeanaID (dataset + localID)")
    @GetMapping(value={"/presentation/{datasetId}/{localId}/annopage"}, headers={"Accept=application/json"})
    public ResponseEntity<String> annoPageInfoJson(@PathVariable String datasetId, @PathVariable String localId, HttpServletRequest request) throws EuropeanaApiException {
        return this.getAnnoPageInfo(datasetId, localId, request, true);
    }

    @Tag(name="All Annopages (JSON-LD)", description="Lists available Annotation Pages for a given EuropeanaID (dataset + localID)")
    @GetMapping(value={"/presentation/{dsId}/{lcId}/annopage"}, headers={"Accept=application/ld+json"})
    public ResponseEntity<String> annoPageInfoJsonLd(@PathVariable String dsId, @PathVariable String lcId, HttpServletRequest request) throws EuropeanaApiException {
        return this.getAnnoPageInfo(dsId, lcId, request, false);
    }

    private ResponseEntity<String> getAnnoPageInfo(String datasetId, String localId, HttpServletRequest request, boolean isJson) throws EuropeanaApiException {
        String eTag;
        AnnoPage annoPage = this.fts.getSingleAnnoPage(datasetId, localId);
        ZonedDateTime modified = CacheUtils.dateToZonedUTC(annoPage.getModified());
        ResponseEntity<String> cached = CacheUtils.checkCached(request, modified, eTag = CacheUtils.generateETag(datasetId + localId, modified, this.fts.getSettings().getAppVersion(), true));
        if (null != cached) {
            LOG.info("Returning cached object for {}, {}", (Object)datasetId, (Object)localId);
            return cached;
        }
        HttpHeaders headers = CacheUtils.generateHeaders(request, eTag, CacheUtils.zonedDateTimeToString(modified));
        AcceptUtils.addContentTypeToResponseHeader((HttpHeaders)headers, (String)"3", (boolean)isJson);
        SummaryManifest apInfo = this.fts.collectionAnnoPageInfo(datasetId, localId);
        return new ResponseEntity((Object)this.fts.serialise(apInfo), (MultiValueMap)headers, HttpStatus.OK);
    }

    @Tag(name="Annopage (JSON)", description="Retrieve a page with annotations")
    @GetMapping(value={"/presentation/{datasetId}/{localId}/annopage/{pageId}"}, headers={"Accept=application/json"})
    public ResponseEntity<String> annoPageJson(@PathVariable String datasetId, @PathVariable String localId, @PathVariable String pageId, @RequestParam(value="lang", required=false) String lang, @RequestParam(value="format", required=false) String versionParam, @RequestParam(value="profile", required=false) String profile, @RequestParam(value="textGranularity", required=false) String textGranularity, HttpServletRequest request) throws EuropeanaApiException {
        return this.annoPage(datasetId, localId, pageId, lang, versionParam, profile, textGranularity, request, true);
    }

    @Tag(name="Annopage (JSON-LD)", description="Retrieve a page with annotations")
    @GetMapping(value={"/presentation/{dsId}/{lcId}/annopage/{pgId}"}, headers={"Accept=application/ld+json"})
    public ResponseEntity<String> annoPageJsonLd(@PathVariable String dsId, @PathVariable String lcId, @PathVariable String pgId, @RequestParam(value="lang", required=false) String lang, @RequestParam(value="format", required=false) String versionParam, @RequestParam(value="profile", required=false) String profile, @RequestParam(value="textGranularity", required=false) String textGranularity, HttpServletRequest request) throws EuropeanaApiException {
        return this.annoPage(dsId, lcId, pgId, lang, versionParam, profile, textGranularity, request, false);
    }

    private ResponseEntity<String> annoPage(String datasetId, String localId, String pageId, String lang, String versionParam, String profileParam, String textGranularity, HttpServletRequest request, boolean isJson) throws EuropeanaApiException {
        String eTag;
        LOG.debug("Retrieve Annopage: {}/{}/{} with language {}", (Object)datasetId, (Object)localId, (Object)pageId, (Object)lang);
        String requestVersion = AcceptUtils.getRequestVersion((HttpServletRequest)request, (String)versionParam);
        if (StringUtils.isEmpty((CharSequence)requestVersion)) {
            throw new InvalidVersionException("Unknown IIIF version in Accept header or format parameter");
        }
        List<AnnotationType> textGranValues = ControllerUtils.validateTextGranularity(textGranularity, ALLOWED_ANNOTATION_TYPES);
        AnnoPage annoPage = this.fts.fetchAnnoPage(datasetId, localId, pageId, textGranValues, lang);
        ZonedDateTime modified = CacheUtils.dateToZonedUTC(annoPage.getModified());
        ResponseEntity<String> cached = CacheUtils.checkCached(request, modified, eTag = CacheUtils.generateETag(datasetId + localId + pageId, modified, requestVersion + this.fts.getSettings().getAppVersion(), true));
        if (null != cached) {
            return cached;
        }
        HttpHeaders headers = CacheUtils.generateHeaders(request, eTag, CacheUtils.zonedDateTimeToString(modified));
        AcceptUtils.addContentTypeToResponseHeader((HttpHeaders)headers, (String)requestVersion, (boolean)isJson);
        List<String> profiles = RequestUtils.extractProfiles(profileParam);
        AnnotationWrapper annotationPage = "3".equalsIgnoreCase(requestVersion) ? this.fts.generateAnnoPageV3(annoPage, textGranValues, profiles.contains("text")) : this.fts.generateAnnoPageV2(annoPage, textGranValues, profiles.contains("text"));
        if (isJson) {
            annotationPage.setContext(null);
        }
        return new ResponseEntity((Object)this.fts.serialise(annotationPage), (MultiValueMap)headers, HttpStatus.OK);
    }

    @Tag(name="Annopage exists (JSON)", description="Check if a page with annotations exists")
    @RequestMapping(value={"/presentation/{datasetId}/{localId}/annopage/{pageId}"}, method={RequestMethod.HEAD}, headers={"Accept=application/json"})
    public ResponseEntity annoPageHeadExistsJson(@PathVariable String datasetId, @PathVariable String localId, @PathVariable String pageId, @RequestParam(value="lang", required=false) String lang, @RequestParam(value="format", required=false) String versionParam, HttpServletRequest request) throws EuropeanaApiException {
        return this.getAnnoPageHead(datasetId, localId, pageId, lang, versionParam, true, request);
    }

    @Tag(name="Annopage exists (JSON-LD)", description="Check if a page with annotations exists")
    @RequestMapping(value={"/presentation/{dsId}/{lcId}/annopage/{pgId}"}, method={RequestMethod.HEAD}, headers={"Accept=application/ld+json"})
    public ResponseEntity annoPageHeadExistsJsonld(@PathVariable String dsId, @PathVariable String lcId, @PathVariable String pgId, @RequestParam(value="lang", required=false) String lang, @RequestParam(value="format", required=false) String versionParam, HttpServletRequest request) throws EuropeanaApiException {
        return this.getAnnoPageHead(dsId, lcId, pgId, lang, versionParam, false, request);
    }

    private ResponseEntity getAnnoPageHead(String datasetId, String localId, String pageId, String lang, String versionParam, boolean isJson, HttpServletRequest request) throws InvalidVersionException {
        String requestVersion = AcceptUtils.getRequestVersion((HttpServletRequest)request, (String)versionParam);
        if (StringUtils.isEmpty((CharSequence)requestVersion)) {
            throw new InvalidVersionException("Unknown IIIF version in Accept header or format parameter");
        }
        HttpHeaders headers = new HttpHeaders();
        AcceptUtils.addContentTypeToResponseHeader((HttpHeaders)headers, (String)requestVersion, (boolean)isJson);
        if (this.fts.doesAnnoPageExist(datasetId, localId, pageId, lang, false)) {
            return new ResponseEntity((MultiValueMap)headers, HttpStatus.OK);
        }
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.NOT_FOUND);
    }

    @Tag(name="Annotation (JSON)", description="Retrieve a single annotation")
    @GetMapping(value={"/presentation/{datasetId}/{localId}/anno/{annoID}"}, headers={"Accept=application/json"})
    public ResponseEntity<String> annotationJson(@PathVariable String datasetId, @PathVariable String localId, @PathVariable String annoID, @RequestParam(value="format", required=false) String versionParam, HttpServletRequest request) throws EuropeanaApiException {
        return this.annotation(datasetId, localId, annoID, versionParam, request, true);
    }

    @Tag(name="Annotation (JSON-LD)", description="Retrieve a single annotation")
    @GetMapping(value={"/presentation/{dsId}/{lcId}/anno/{annoID}"}, headers={"Accept=application/ld+json"})
    public ResponseEntity<String> annotationJsonLd(@PathVariable String dsId, @PathVariable String lcId, @PathVariable String annoID, @RequestParam(value="format", required=false) String versionParam, HttpServletRequest request) throws EuropeanaApiException {
        return this.annotation(dsId, lcId, annoID, versionParam, request, false);
    }

    private ResponseEntity<String> annotation(String datasetId, String localId, String annoID, String versionParam, HttpServletRequest request, boolean isJson) throws EuropeanaApiException {
        String eTag;
        LOG.debug("Retrieve Annotation: {}/{}/{}", (Object)datasetId, (Object)localId, (Object)annoID);
        String requestVersion = AcceptUtils.getRequestVersion((HttpServletRequest)request, (String)versionParam);
        if (StringUtils.isEmpty((CharSequence)requestVersion)) {
            throw new InvalidVersionException("Unknown IIIF version in Accept header or format parameter");
        }
        AnnoPage annoPage = this.fts.fetchAPAnnotation(datasetId, localId, annoID);
        ZonedDateTime modified = CacheUtils.dateToZonedUTC(annoPage.getModified());
        ResponseEntity<String> cached = CacheUtils.checkCached(request, modified, eTag = CacheUtils.generateETag(datasetId + localId + annoID, modified, requestVersion + this.fts.getSettings().getAppVersion(), true));
        if (cached != null) {
            return cached;
        }
        HttpHeaders headers = CacheUtils.generateHeaders(request, eTag, CacheUtils.zonedDateTimeToString(modified));
        AcceptUtils.addContentTypeToResponseHeader((HttpHeaders)headers, (String)requestVersion, (boolean)isJson);
        AnnotationWrapper annotation = "3".equalsIgnoreCase(requestVersion) ? this.fts.generateAnnotationV3(annoPage, annoID) : this.fts.generateAnnotationV2(annoPage, annoID);
        if (isJson) {
            annotation.setContext(null);
        }
        return new ResponseEntity((Object)this.fts.serialise(annotation), (MultiValueMap)headers, HttpStatus.OK);
    }

    @Tag(name="Fulltext resource (JSON-LD)", description="Retrieve a full-text")
    @GetMapping(value={"/presentation/{datasetId}/{localId}/{pageId}"}, headers={"Accept=application/ld+json"}, produces={"application/ld+json;charset=UTF-8"})
    public ResponseEntity<String> resourceJsonLd(@PathVariable String datasetId, @PathVariable String localId, @PathVariable String pageId, @RequestParam(value="lang", required=false) String lang, HttpServletRequest request) throws EuropeanaApiException {
        return this.resource(datasetId, localId, pageId, lang, request, false);
    }

    @Tag(name="Fulltext resource (JSON)", description="Retrieve a full-text")
    @GetMapping(value={"/presentation/{dsId}/{lcId}/{pgId}"}, headers={"Accept=application/json"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> resourceJson(@PathVariable String dsId, @PathVariable String lcId, @PathVariable String pgId, @RequestParam(value="lang", required=false) String lang, HttpServletRequest request) throws EuropeanaApiException {
        return this.resource(dsId, lcId, pgId, lang, request, true);
    }

    private ResponseEntity<String> resource(String datasetId, String localId, String pageId, String lang, HttpServletRequest request, boolean isJson) throws EuropeanaApiException {
        LOG.debug("Retrieve Resource: {}/{}/{}", (Object)datasetId, (Object)localId, (Object)pageId);
        FTResource resource = this.fts.fetchFTResource(datasetId, localId, pageId, lang);
        ZonedDateTime modified = CacheUtils.januarificator();
        String eTag = CacheUtils.generateSimpleETag(datasetId + localId + pageId + resource.getLanguage() + resource.getValue() + this.fts.getSettings().getAppVersion(), true);
        ResponseEntity<String> cached = CacheUtils.checkCached(request, modified, eTag);
        if (cached != null) {
            return cached;
        }
        HttpHeaders headers = CacheUtils.generateHeaders(request, eTag, CacheUtils.zonedDateTimeToString(modified));
        headers.add("Content-Type", (isJson ? "application/json" : "application/ld+json") + ";charset=UTF-8");
        if (isJson) {
            resource.setContext(null);
        }
        return new ResponseEntity((Object)this.fts.serialise(resource), (MultiValueMap)headers, HttpStatus.OK);
    }

    private static String[] setSummaryTextGranularity(boolean isMedia) {
        List<AnnotationType> granularities = isMedia ? List.copyOf(FTDefinitions.MEDIA_ANNOTATION_TYPES) : List.copyOf(FTDefinitions.TEXT_ANNOTATION_TYPES);
        ArrayList<String> textGranularity = new ArrayList<String>();
        for (AnnotationType granularity : granularities) {
            textGranularity.add(granularity.getLowerCaseName());
        }
        return textGranularity.toArray(new String[0]);
    }
}

