/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.config;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import dev.morphia.Datastore;
import dev.morphia.Morphia;
import dev.morphia.mapping.MapperOptions;
import eu.europeana.fulltext.api.config.FTSettings;
import eu.europeana.fulltext.entity.FulltextPackageMapper;
import eu.europeana.fulltext.util.MorphiaUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class DataSourceConfig {
    private final FTSettings settings;
    private static final Logger logger = LogManager.getLogger(DataSourceConfig.class);

    public DataSourceConfig(FTSettings settings) {
        this.settings = settings;
    }

    @Bean
    public MongoClient mongoClient() {
        return MongoClients.create((String)this.settings.getMongoConnectionUrl());
    }

    @Bean(value={"fulltextDatastore"})
    @Primary
    public Datastore fulltextDatastore(MongoClient mongoClient) {
        String fulltextDatabase = this.settings.getFulltextDatabase();
        logger.info("Configuring fulltext database: {}", (Object)fulltextDatabase);
        Datastore datastore = Morphia.createDatastore((MongoClient)mongoClient, (String)fulltextDatabase, (MapperOptions)MorphiaUtils.MAPPER_OPTIONS);
        if (this.settings.ensureFulltextIndices()) {
            datastore.getMapper().mapPackage(FulltextPackageMapper.class.getPackageName());
            datastore.ensureIndexes();
        }
        return datastore;
    }
}

