/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api;

import eu.europeana.fulltext.api.web.SocksProxyConfigInjector;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.logging.log4j.LogManager;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.security.servlet.ManagementWebSecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@SpringBootApplication(scanBasePackages={"eu.europeana.fulltext"}, exclude={SecurityAutoConfiguration.class, ManagementWebSecurityAutoConfiguration.class})
@PropertySource(value={"classpath:build.properties"})
public class FTApplication
extends SpringBootServletInitializer {
    public static final int THOUSAND = 1000;

    public static void main(String[] args) {
        LogManager.getLogger(FTApplication.class).info("CF_INSTANCE_INDEX  = {}, CF_INSTANCE_GUID = {}, CF_INSTANCE_IP  = {}", (Object)System.getenv("CF_INSTANCE_INDEX"), (Object)System.getenv("CF_INSTANCE_GUID"), (Object)System.getenv("CF_INSTANCE_IP"));
        try {
            FTApplication.injectSocksProxySettings();
            SpringApplication.run(FTApplication.class, (String[])args);
        }
        catch (IOException e) {
            LogManager.getLogger(FTApplication.class).fatal("Error reading properties file", (Throwable)e);
            System.exit(-1);
        }
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        LogManager.getLogger(FTApplication.class).info("CF_INSTANCE_INDEX  = {}, CF_INSTANCE_GUID = {}, CF_INSTANCE_IP  = {}", (Object)System.getenv("CF_INSTANCE_INDEX"), (Object)System.getenv("CF_INSTANCE_GUID"), (Object)System.getenv("CF_INSTANCE_IP"));
        try {
            FTApplication.injectSocksProxySettings();
            super.onStartup(servletContext);
        }
        catch (IOException e) {
            throw new ServletException("Error reading properties", (Throwable)e);
        }
    }

    private static void injectSocksProxySettings() throws IOException {
        SocksProxyConfigInjector socksConfig = new SocksProxyConfigInjector("fulltext.properties");
        try {
            socksConfig.addProperties("fulltext.user.properties");
        }
        catch (IOException e) {
            LogManager.getLogger(FTApplication.class).warn("Cannot read fulltext.user.properties file. Reason: ", (Object)e.getMessage());
        }
        socksConfig.inject();
    }

    @Bean
    public CorsFilter corsFilter() {
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(false));
        config.setAllowedHeaders(Collections.singletonList("*"));
        config.setAllowedOrigins(Collections.singletonList("*"));
        config.setAllowedMethods(Collections.singletonList("*"));
        config.setMaxAge(Long.valueOf(1000L));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", config);
        return new CorsFilter((CorsConfigurationSource)source);
    }
}

