/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.util;

import eu.europeana.fulltext.exception.InvalidRequestParamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;

public class RequestUtils {
    public static final Pattern ACCEPT_PROFILE_PATTERN = Pattern.compile("profile=\"(.*?)\"");
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_JSON = "Accept=application/json";
    public static final String ACCEPT_JSONLD = "Accept=application/ld+json";
    public static final String ACCEPT_VERSION_INVALID = "Unknown profile version indicated either in Accept or using the format field";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String PROFILE_TEXT = "text";
    public static final String PROFILE_DEBUG = "debug";
    public static final String REQUEST_VERSION_2 = "2";
    public static final String REQUEST_VERSION_3 = "3";

    public static String getRequestVersion(HttpServletRequest request, String format) {
        Matcher m;
        String result = null;
        String accept = request.getHeader(ACCEPT);
        if (StringUtils.isNotEmpty((CharSequence)accept) && (m = ACCEPT_PROFILE_PATTERN.matcher(accept)).find()) {
            String profiles = m.group(1);
            result = profiles.toLowerCase(Locale.getDefault()).contains("http://iiif.io/api/presentation/3/context.json") ? REQUEST_VERSION_3 : (profiles.toLowerCase(Locale.getDefault()).contains("http://iiif.io/api/presentation/2/context.json") ? REQUEST_VERSION_2 : null);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)format)) {
            result = REQUEST_VERSION_2;
        } else if (REQUEST_VERSION_2.equals(format) || REQUEST_VERSION_3.equals(format)) {
            result = format;
        }
        return result;
    }

    public static void addContentTypeToResponseHeader(HttpHeaders headers, String version, boolean isJson) {
        if (REQUEST_VERSION_3.equalsIgnoreCase(version)) {
            if (isJson) {
                headers.add(CONTENT_TYPE, "application/json;profile=\"http://iiif.io/api/presentation/3/context.json\";charset=UTF-8");
            } else {
                headers.add(CONTENT_TYPE, "application/ld+json;profile=\"http://iiif.io/api/presentation/3/context.json\";charset=UTF-8");
            }
        } else if (isJson) {
            headers.add(CONTENT_TYPE, "application/json;profile=\"http://iiif.io/api/presentation/2/context.json\";charset=UTF-8");
        } else {
            headers.add(CONTENT_TYPE, "application/ld+json;profile=\"http://iiif.io/api/presentation/2/context.json\";charset=UTF-8");
        }
    }

    public static List<String> extractProfiles(String profileParam) throws InvalidRequestParamException {
        List<String> profiles = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)profileParam)) {
            profiles = Arrays.asList(StringUtils.split((String)profileParam, (String)","));
            for (String val : profiles) {
                if (StringUtils.equals((CharSequence)val, (CharSequence)PROFILE_TEXT) || StringUtils.equals((CharSequence)val, (CharSequence)PROFILE_DEBUG)) continue;
                throw new InvalidRequestParamException("profile", val);
            }
        }
        return profiles;
    }
}

