/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.util;

import eu.europeana.fulltext.AnnotationType;
import eu.europeana.fulltext.edm.EdmAnnotation;
import eu.europeana.fulltext.edm.EdmFullTextPackage;
import eu.europeana.fulltext.edm.EdmFullTextResource;
import eu.europeana.fulltext.edm.EdmTextBoundary;
import eu.europeana.fulltext.edm.EdmTimeBoundary;
import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.entity.Annotation;
import eu.europeana.fulltext.entity.Resource;
import eu.europeana.fulltext.entity.Target;
import eu.europeana.fulltext.exception.MismatchInAnnotationException;
import eu.europeana.fulltext.subtitles.AnnotationPreview;
import eu.europeana.fulltext.util.GeneralUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class EdmToFullTextConverter {
    private EdmToFullTextConverter() {
    }

    public static AnnoPage createAnnoPage(String datasetId, String localId, AnnotationPreview request, EdmFullTextPackage fulltext, boolean isContributed) throws MismatchInAnnotationException {
        Resource resource = EdmToFullTextConverter.getResource((EdmFullTextResource)fulltext.getResource(), (AnnotationPreview)request, (String)datasetId, (String)localId, (boolean)isContributed);
        AnnoPage annoPage = new AnnoPage();
        annoPage.setDsId(datasetId);
        annoPage.setLcId(localId);
        annoPage.setPgId(GeneralUtils.derivePageId((String)request.getMedia()));
        annoPage.setTgtId(request.getMedia());
        annoPage.setLang(request.getLanguage());
        if (!StringUtils.isEmpty((CharSequence)request.getSource())) {
            annoPage.setSource(request.getSource());
        }
        annoPage.setRes(resource);
        annoPage.setAns(EdmToFullTextConverter.getAnnotations((EdmFullTextPackage)fulltext, (String)request.getMedia(), (String)request.getLanguage()));
        annoPage.setSource(request.getSource());
        annoPage.setTranslation(!request.isOriginalLang());
        if (annoPage.getAns().size() != fulltext.size()) {
            throw new MismatchInAnnotationException("Mismatch in Annotations while converting from EDM to fulltext. Annotations obtained - " + fulltext.size() + ". Annotations converted - " + annoPage.getAns().size());
        }
        return annoPage;
    }

    private static Resource getResource(EdmFullTextResource ftResource, AnnotationPreview request, String datasetId, String localId, boolean isContributed) {
        Resource resource = new Resource();
        resource.setContributed(isContributed);
        resource.setId(EdmToFullTextConverter.getFulltextResourceId((String)ftResource.getFullTextResourceURI(), (String)request.getRecordId()));
        resource.setLang(request.getLanguage());
        resource.setValue(ftResource.getValue());
        resource.setRights(request.getRights());
        resource.setDsId(datasetId);
        resource.setLcId(localId);
        resource.setPgId(GeneralUtils.derivePageId((String)request.getMedia()));
        resource.setTranslation(!request.isOriginalLang());
        return resource;
    }

    private static List<Annotation> getAnnotations(EdmFullTextPackage fulltext, String mediaUrl, String language) {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        for (EdmAnnotation sourceAnnotation : fulltext) {
            EdmTextBoundary boundary = (EdmTextBoundary)sourceAnnotation.getTextReference();
            ArrayList<Target> targets = new ArrayList<Target>();
            if (sourceAnnotation.hasTargets()) {
                EdmTimeBoundary tB = (EdmTimeBoundary)sourceAnnotation.getTargets().get(0);
                targets.add(new Target(Integer.valueOf(tB.getStart()), Integer.valueOf(tB.getEnd())));
            }
            Annotation annotation = new Annotation();
            if (EdmToFullTextConverter.isTopLevel((EdmAnnotation)sourceAnnotation)) {
                annotation.setDcType(sourceAnnotation.getType().getAbbreviation());
            } else {
                annotation.setDcType(sourceAnnotation.getType().getAbbreviation());
                annotation.setFrom(Integer.valueOf(boundary.getFrom()));
                annotation.setTo(Integer.valueOf(boundary.getTo()));
                annotation.setTgs(targets);
            }
            annotation.setAnId(GeneralUtils.createAnnotationHash((Annotation)annotation, (String)mediaUrl, (String)language));
            annotationList.add(annotation);
        }
        return annotationList;
    }

    private static String getFulltextResourceId(String fulltextResourceUri, String itemID) {
        return StringUtils.substringAfter((String)fulltextResourceUri, (String)("http://data.europeana.eu/fulltext" + itemID + "/"));
    }

    public static boolean isTopLevel(EdmAnnotation annotation) {
        return annotation.getType().equals((Object)AnnotationType.MEDIA) || annotation.getType().equals((Object)AnnotationType.PAGE);
    }
}

