/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.util;

import eu.europeana.fulltext.exception.MediaTypeNotSupportedException;
import eu.europeana.fulltext.subtitles.AnnotationPreview;
import eu.europeana.fulltext.subtitles.FulltextType;
import eu.europeana.fulltext.subtitles.external.AnnotationItem;
import eu.europeana.fulltext.util.GeneralUtils;
import org.apache.commons.lang3.StringUtils;

public class AnnotationUtils {
    public static AnnotationPreview createAnnotationPreview(AnnotationItem item) throws MediaTypeNotSupportedException {
        FulltextType fulltextType = FulltextType.getValueByMimetype((String)item.getBody().getFormat());
        if (fulltextType == null) {
            throw new MediaTypeNotSupportedException(String.format("Unsupported mimeType in Annotation id=%s body.format=%s", item.getId(), item.getBody().getFormat()));
        }
        return new AnnotationPreview.Builder(GeneralUtils.getRecordIdFromUri((String)item.getTarget().getScope()), fulltextType, item.getBody().getValue()).setSource(item.getId()).setMedia(item.getTarget().getSource()).setLanguage(item.getBody().getLanguage()).setRights(item.getBody().getEdmRights()).setOriginalLang("captioning".equals(item.getMotivation()) || "transcribing".equals(item.getMotivation())).build();
    }

    public static AnnotationPreview createAnnotationPreview(String datasetId, String localId, String lang, boolean originalLang, String rights, String source, String media, String content, FulltextType type) {
        String recordId = GeneralUtils.generateRecordId((String)datasetId, (String)localId);
        if (type != null && type.equals((Object)FulltextType.PLAIN)) {
            originalLang = true;
        }
        return new AnnotationPreview.Builder(recordId, type, content).setOriginalLang(originalLang).setLanguage(lang).setRights(rights).setMedia(media).setSource(source).build();
    }

    public static boolean isAnnoPageUpdateRequired(AnnotationPreview preview) {
        return StringUtils.isNotEmpty((CharSequence)preview.getSource()) || StringUtils.isNotEmpty((CharSequence)preview.getAnnotationBody());
    }
}

