/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.search.web;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.fulltext.AnnotationType;
import eu.europeana.fulltext.api.config.FTSettings;
import eu.europeana.fulltext.api.service.ControllerUtils;
import eu.europeana.fulltext.api.service.exception.InvalidVersionException;
import eu.europeana.fulltext.search.exception.InvalidParameterException;
import eu.europeana.fulltext.search.exception.SearchDisabledException;
import eu.europeana.fulltext.search.model.query.EuropeanaId;
import eu.europeana.fulltext.search.model.response.SearchResult;
import eu.europeana.fulltext.search.service.FTSearchService;
import eu.europeana.fulltext.util.RequestUtils;
import io.swagger.annotations.Api;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Full-text search"}, description="Search all full-texts that are part of an item (e.g. newspaper issue)")
@RestController
@RequestMapping(value={"/presentation"})
public class FTSearchController {
    public static final Set<AnnotationType> ALLOWED_ANNOTATION_TYPES = EnumSet.of(AnnotationType.BLOCK, AnnotationType.LINE, AnnotationType.WORD);
    private static final Logger LOG = LogManager.getLogger(FTSearchController.class);
    private final FTSearchService searchService;
    private final FTSettings settings;

    public FTSearchController(FTSearchService searchService, FTSettings settings) {
        this.searchService = searchService;
        this.settings = settings;
    }

    @GetMapping(value={"/{datasetId}/{localId}/search"}, produces={"application/json"})
    public ResponseEntity searchIssue(@PathVariable String datasetId, @PathVariable String localId, @RequestParam(required=false) String query, @RequestParam(required=false) String q, @RequestParam(required=false, defaultValue="12") int pageSize, @RequestParam(required=false) String textGranularity, @RequestParam(value="format", required=false) String versionParam, @RequestParam(required=false) String debug, HttpServletRequest request) throws EuropeanaApiException {
        if (!this.settings.isSolrEnabled()) {
            throw new SearchDisabledException();
        }
        String requestVersion = RequestUtils.getRequestVersion((HttpServletRequest)request, (String)versionParam);
        if (StringUtils.isEmpty((CharSequence)requestVersion)) {
            throw new InvalidVersionException("Unknown profile version indicated either in Accept or using the format field");
        }
        String qry = this.validateQuery(query, q);
        if (pageSize < 1 || pageSize > 100) {
            throw new InvalidParameterException("Page size should be between 1 and 100");
        }
        List annoTypes = this.validateTextGranularity(textGranularity);
        String searchId = request.getRequestURI() + "?" + request.getQueryString();
        SearchResult searchResult = this.searchService.searchIssue(searchId, new EuropeanaId(datasetId, localId), qry, pageSize, annoTypes, requestVersion, debug != null);
        return new ResponseEntity((Object)searchResult, HttpStatus.OK);
    }

    private String validateQuery(String query, String q) throws EuropeanaApiException {
        if (StringUtils.isEmpty((CharSequence)query) && StringUtils.isEmpty((CharSequence)q)) {
            throw new InvalidParameterException("No or empty query parameter");
        }
        if (!StringUtils.isEmpty((CharSequence)query)) {
            if (!StringUtils.isEmpty((CharSequence)q)) {
                LOG.warn("Both query and q parameters are specified. Ignoring the q parameter");
            }
            return query;
        }
        return q;
    }

    List<AnnotationType> validateTextGranularity(String textGranularityParams) throws InvalidParameterException {
        if (textGranularityParams == null) {
            return this.settings.getDefaultSearchTextGranularity();
        }
        return ControllerUtils.validateTextGranularity((String)textGranularityParams, (Set)ALLOWED_ANNOTATION_TYPES);
    }
}

