/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.search.service;

import dev.morphia.query.internal.MorphiaCursor;
import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.fulltext.AnnotationType;
import eu.europeana.fulltext.api.service.FTService;
import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.entity.Annotation;
import eu.europeana.fulltext.search.exception.RecordDoesNotExistException;
import eu.europeana.fulltext.search.exception.SearchEngineDatabaseMismatch;
import eu.europeana.fulltext.search.model.query.EuropeanaId;
import eu.europeana.fulltext.search.model.query.SolrHit;
import eu.europeana.fulltext.search.model.response.Debug;
import eu.europeana.fulltext.search.model.response.Hit;
import eu.europeana.fulltext.search.model.response.HitFactory;
import eu.europeana.fulltext.search.model.response.SearchResult;
import eu.europeana.fulltext.search.model.response.SearchResultFactory;
import eu.europeana.fulltext.search.repository.SolrRepo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.common.util.NamedList;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class FTSearchService {
    private static final Logger LOG = LogManager.getLogger(FTSearchService.class);
    private static final String SNIPPETS = "snippets";
    private static final String OFFSETS = "passages";
    private static final String TEXT_START_OFFSET = "startOffsetUtf16";
    private static final String HIT_START_OFFSETS = "matchStartsUtf16";
    private static final String HIT_END_OFFSETS = "matchEndsUtf16";
    private SolrRepo solrRepo;
    private FTService fulltextRepo;

    FTSearchService(SolrRepo solrRepo, FTService fulltextService) {
        this.solrRepo = solrRepo;
        this.fulltextRepo = fulltextService;
    }

    public SearchResult searchIssue(String searchId, EuropeanaId europeanaId, String query, int pageSize, List<AnnotationType> annoTypes, String requestVersion, boolean debug) throws EuropeanaApiException {
        long start = System.currentTimeMillis();
        SearchResult result = SearchResultFactory.createSearchResult((String)searchId, (boolean)debug, (String)requestVersion);
        Map solrResult = this.solrRepo.getHighlightsWithOffsets(europeanaId, query, pageSize, result.getDebug());
        if (solrResult.isEmpty()) {
            LOG.debug("Solr returned empty result in {} ms", (Object)(System.currentTimeMillis() - start));
            List existingAnnoPages = this.fulltextRepo.getAnnoPages(europeanaId.getDatasetId(), europeanaId.getLocalId(), null, false);
            if (existingAnnoPages.isEmpty()) {
                LOG.debug("No record for europeana Id {} in Mongo", (Object)europeanaId);
                throw new RecordDoesNotExistException(europeanaId);
            }
        } else {
            LOG.debug("Solr returned {} document in {} ms", (Object)solrResult.size(), (Object)(System.currentTimeMillis() - start));
            this.findAnnopageAndAnnotations(result, solrResult, europeanaId, pageSize, annoTypes, requestVersion);
        }
        LOG.debug("Search done in {} ms. Found {} annotations", (Object)(System.currentTimeMillis() - start), (Object)result.itemSize());
        return result;
    }

    private void findAnnopageAndAnnotations(SearchResult result, Map<String, List<String>> highlightInfo, EuropeanaId europeanaId, int pageSize, List<AnnotationType> annoTypes, String requestVersion) throws EuropeanaApiException {
        Map<String, List<SolrHit>> solrHitsByImageId = this.parseHighlightData(highlightInfo, result.getDebug()).stream().collect(Collectors.groupingBy(SolrHit::getImageId));
        long start = System.currentTimeMillis();
        ArrayList<String> targetIds = new ArrayList<String>(solrHitsByImageId.keySet());
        try (MorphiaCursor annoPageCursor = this.fulltextRepo.fetchAnnoPageFromTargetId(europeanaId.getDatasetId(), europeanaId.getLocalId(), targetIds, annoTypes, false);){
            if (annoPageCursor == null || !annoPageCursor.hasNext()) {
                LOG.error("Solr record {} with targetIds {} not found in Mongo!", (Object)europeanaId, targetIds);
                throw new SearchEngineDatabaseMismatch();
            }
            LOG.debug("Retrieved AnnoPages for {} in {} ms", (Object)europeanaId, (Object)(System.currentTimeMillis() - start));
            while (annoPageCursor.hasNext()) {
                AnnoPage annoPage = (AnnoPage)annoPageCursor.next();
                LOG.debug("Processing annoPage {}", (Object)annoPage);
                for (SolrHit solrHit : solrHitsByImageId.get(annoPage.getTgtId())) {
                    this.findAnnotations(result, solrHit, annoPage, pageSize, annoTypes, requestVersion);
                    if (result.itemSize() < pageSize) continue;
                    return;
                }
            }
        }
    }

    private void findAnnotations(SearchResult result, SolrHit solrHit, AnnoPage annoPage, int pageSize, List<AnnotationType> annoTypes, String requestVersion) {
        LOG.trace("  Searching for {} annotations that overlap with {}...", annoTypes, (Object)solrHit.getDebugInfo());
        boolean annotationsFound = false;
        for (Annotation anno : annoPage.getAns()) {
            if (anno.getFrom() != null && anno.getTo() != null && this.overlap(solrHit.getStart(), solrHit.getEnd(), anno.getFrom().intValue(), anno.getTo().intValue())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Found overlap between {} and annotation {},{} with text '{}'", (Object)solrHit.getDebugInfo(), (Object)anno.getFrom(), (Object)anno.getTo(), (Object)annoPage.getRes().getValue().substring(anno.getFrom(), anno.getTo()));
                }
                if (anno.getTo() - anno.getFrom() > 1) {
                    annotationsFound = true;
                    if (anno.getDcType() == AnnotationType.WORD.getAbbreviation()) {
                        result.addAnnotationHit(annoPage, anno, null);
                    } else {
                        Hit hit = HitFactory.createHit((int)solrHit.getStart(), (int)solrHit.getEnd(), (AnnoPage)annoPage, (Annotation)anno, (String)requestVersion);
                        result.addAnnotationHit(annoPage, anno, hit);
                    }
                } else {
                    LOG.debug("Ignoring overlap with annotation {} because it's only 1 character long", (Object)anno.getAnId());
                }
            }
            if (result.itemSize() < pageSize) continue;
            break;
        }
        if (!annotationsFound) {
            LOG.warn("No annotations found for {},{} on /{}/{}/annopage/{}", (Object)solrHit.getStart(), (Object)solrHit.getEnd(), (Object)annoPage.getDsId(), (Object)annoPage.getLcId(), (Object)annoPage.getPgId());
        }
    }

    private List<SolrHit> parseHighlightData(Map<String, List<String>> highlightInfo, Debug debug) throws EuropeanaApiException {
        List<String> highlightObj = highlightInfo.values().iterator().next();
        if (!(highlightObj instanceof NamedList)) {
            throw new EuropeanaApiException("Unexpected highlights object type: " + (highlightObj == null ? null : highlightObj.getClass()));
        }
        NamedList namedList = (NamedList)highlightObj;
        ArrayList snippetsTxt = (ArrayList)namedList.get(SNIPPETS);
        ArrayList offsetsLists = (ArrayList)namedList.get(OFFSETS);
        ArrayList<SolrHit> result = new ArrayList<SolrHit>();
        int nrMergedHits = 0;
        for (int i = 0; i < snippetsTxt.size(); ++i) {
            String snippetTxt = (String)snippetsTxt.get(i);
            int imageIdEnd = snippetTxt.indexOf(125);
            String imageId = StringEscapeUtils.unescapeXml((String)snippetTxt.substring(1, imageIdEnd));
            String snippet = snippetTxt.substring(imageIdEnd + 2);
            NamedList offsetList = (NamedList)offsetsLists.get(i);
            Long textStartOffset = Long.valueOf(offsetList.get(TEXT_START_OFFSET).toString());
            textStartOffset = textStartOffset + (long)imageIdEnd + 2L;
            List starts = this.getOffsets(offsetList.get(HIT_START_OFFSETS).toString(), textStartOffset.longValue());
            List ends = this.getOffsets(offsetList.get(HIT_END_OFFSETS).toString(), textStartOffset.longValue());
            SolrHit previousHit = null;
            for (int j = 0; j < starts.size(); ++j) {
                SolrHit newHit = new SolrHit(imageId, snippet, ((Integer)starts.get(j)).intValue(), ((Integer)ends.get(j)).intValue());
                if (previousHit != null && newHit.getStart() - previousHit.getEnd() <= 3) {
                    LOG.debug("Merging {} with {}...", (Object)previousHit.getDebugInfo(), (Object)newHit.getDebugInfo());
                    previousHit.setEnd(newHit.getEnd());
                    ++nrMergedHits;
                } else {
                    result.add(newHit);
                    if (debug != null) {
                        debug.addSolrSnippet(newHit);
                    }
                }
                previousHit = newHit;
            }
        }
        LOG.debug("Parsed {} solr hits, {} merged", (Object)(result.size() + nrMergedHits), (Object)nrMergedHits);
        return result;
    }

    private List<Integer> getOffsets(String numberArrayTxt, long textStartOffset) {
        String numbersTxt = numberArrayTxt.substring(1, numberArrayTxt.length() - 1);
        String[] numbers = numbersTxt.split(", ");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String number : numbers) {
            Long value = Long.parseLong(number) - textStartOffset;
            if (value < 0L) continue;
            result.add(value.intValue());
        }
        return result;
    }

    private boolean overlap(int s1, int e1, int s2, int e2) {
        return s1 <= e2 && e1 >= s2;
    }
}

