/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.search.model.response.v3;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import eu.europeana.fulltext.api.model.v3.AnnotationV3;
import eu.europeana.fulltext.api.service.EDM2IIIFMapping;
import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.entity.Annotation;
import eu.europeana.fulltext.search.model.response.Debug;
import eu.europeana.fulltext.search.model.response.Hit;
import eu.europeana.fulltext.search.model.response.SearchResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonPropertyOrder(value={"id", "type", "debug", "items", "hits"})
public class SearchResultV3
implements Serializable,
SearchResult {
    private static final long serialVersionUID = -5643549600050178321L;
    private static final String TYPE = "AnnotationPage";
    private String id;
    private Debug debug;
    private List<AnnotationV3> items = new ArrayList();
    private List<Hit> hits = new ArrayList();

    public SearchResultV3(String searchId, boolean debug) {
        this.id = searchId;
        if (debug) {
            this.debug = new Debug();
        }
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return TYPE;
    }

    public Debug getDebug() {
        return this.debug;
    }

    public int itemSize() {
        return this.items.size();
    }

    public List<AnnotationV3> getItems() {
        return this.items;
    }

    public List<Hit> getHits() {
        return this.hits;
    }

    public void addAnnotationHit(AnnoPage annoPage, Annotation annotation, Hit hit) {
        AnnotationV3 annoV3 = EDM2IIIFMapping.getAnnotationV3((AnnoPage)annoPage, (Annotation)annotation, (boolean)false, (boolean)false);
        this.items.add(annoV3);
        if (hit != null) {
            this.hits.add(hit);
        }
    }
}

