/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.edm;

import eu.europeana.fulltext.AnnotationType;
import eu.europeana.fulltext.edm.EdmReference;
import eu.europeana.fulltext.edm.EdmTimeBoundary;
import java.util.ArrayList;
import java.util.List;

public class EdmAnnotation {
    private final EdmReference textReference;
    private final List<EdmTimeBoundary> targets = new ArrayList(1);
    private final AnnotationType type;
    private final String lang;
    private final Float confidence;

    public EdmAnnotation(EdmReference textReference, EdmTimeBoundary target, AnnotationType type, String lang, Float confidence) {
        this.textReference = textReference;
        if (target != null) {
            this.targets.add(target);
        }
        this.type = type;
        this.lang = lang;
        this.confidence = confidence;
    }

    public EdmReference getTextReference() {
        return this.textReference;
    }

    public List<EdmTimeBoundary> getTargets() {
        return this.targets;
    }

    public AnnotationType getType() {
        return this.type;
    }

    public String getLang() {
        return this.lang;
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public boolean hasTargets() {
        return !this.targets.isEmpty();
    }
}

