/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.batch.writer;

import eu.europeana.fulltext.api.service.FTService;
import eu.europeana.fulltext.batch.AnnoSyncStats;
import java.util.List;
import org.springframework.batch.item.ItemWriter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class AnnoPageDeprecationWriter
implements ItemWriter<String> {
    private final FTService ftService;
    private final AnnoSyncStats statsCounter;

    public AnnoPageDeprecationWriter(FTService ftWriteService, AnnoSyncStats statsCounter) {
        this.ftService = ftWriteService;
        this.statsCounter = statsCounter;
    }

    public void write(@NonNull List<? extends String> annoPages) throws Exception {
        long deletedCount = this.ftService.deprecateAnnoPagesWithSources(annoPages);
        int i = 0;
        while ((long)i < deletedCount) {
            this.statsCounter.addDeprecated();
            ++i;
        }
    }
}

