/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.batch.reader;

import eu.europeana.fulltext.api.service.AnnotationApiRestService;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.item.data.AbstractPaginatedDataItemReader;

public class DeletedAnnotationsReader
extends AbstractPaginatedDataItemReader<String> {
    private final AnnotationApiRestService annotationsRestService;
    private final Instant from;
    private final Instant to;

    public DeletedAnnotationsReader(AnnotationApiRestService annotationsRestService, int pageSize, Instant from, Instant to) {
        this.setPageSize(pageSize);
        this.annotationsRestService = annotationsRestService;
        this.from = from;
        this.to = to;
        this.setSaveState(false);
    }

    protected Iterator<String> doPageRead() {
        List deletedAnnotations = this.annotationsRestService.getDeletedAnnotations(this.page, this.pageSize, this.from, this.to);
        if (deletedAnnotations == null || deletedAnnotations.isEmpty()) {
            return null;
        }
        return deletedAnnotations.iterator();
    }
}

