/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.batch.reader;

import eu.europeana.fulltext.api.service.AnnotationApiRestService;
import eu.europeana.fulltext.subtitles.external.AnnotationItem;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.item.data.AbstractPaginatedDataItemReader;

public class AnnotationItemReader
extends AbstractPaginatedDataItemReader<AnnotationItem> {
    private final AnnotationApiRestService annotationsRestService;
    private final Instant from;
    private final Instant to;

    public AnnotationItemReader(AnnotationApiRestService annotationsRestService, int pageSize, Instant from, Instant to) {
        this.setPageSize(pageSize);
        this.annotationsRestService = annotationsRestService;
        this.from = from;
        this.to = to;
        this.setSaveState(false);
    }

    String getClassName() {
        return AnnotationItemReader.class.getSimpleName();
    }

    protected Iterator<AnnotationItem> doPageRead() {
        List searchResponse = this.annotationsRestService.getAnnotations(this.page, this.pageSize, this.from, this.to);
        if (searchResponse == null || searchResponse.isEmpty()) {
            return null;
        }
        return searchResponse.iterator();
    }

    protected void doOpen() throws Exception {
        super.doOpen();
        this.setName(this.getClassName());
    }
}

