/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.batch.listener;

import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.subtitles.external.AnnotationItem;
import eu.europeana.fulltext.util.GeneralUtils;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.batch.core.listener.ItemListenerSupport;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class AnnoSyncUpdateListener
extends ItemListenerSupport<AnnotationItem, AnnoPage> {
    private static final Logger logger = LogManager.getLogger(AnnoSyncUpdateListener.class);

    public void onReadError(@NonNull Exception e) {
        logger.error("onReadError", (Throwable)e);
    }

    public void onProcessError(@NonNull AnnotationItem item, @NonNull Exception e) {
        logger.error("Error processing AnnotationItem id={}; recordId={}", (Object)item.getId(), (Object)item.getTarget().getScope(), (Object)e);
    }

    public void onWriteError(@NonNull Exception ex, @NonNull List<? extends AnnoPage> annoPages) {
        logger.error("Error saving AnnoPages {}, ", (Object)GeneralUtils.getAnnoPageToString(annoPages), (Object)ex);
    }
}

