/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.batch;

import eu.europeana.fulltext.api.config.FTSettings;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
public class BatchBeanConfig {
    private final FTSettings appSettings;

    public BatchBeanConfig(FTSettings appSettings) {
        this.appSettings = appSettings;
    }

    @Bean(value={"annoSyncTaskExecutor"})
    public TaskExecutor annoSyncTaskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(this.appSettings.getBatchCorePoolSize());
        taskExecutor.setMaxPoolSize(this.appSettings.getBatchMaxPoolSize());
        taskExecutor.setQueueCapacity(this.appSettings.getBatchQueueSize());
        return taskExecutor;
    }

    @Bean(value={"jobLauncherTaskExecutor"})
    public TaskExecutor jobLauncherTaskExecutor() {
        return new SyncTaskExecutor();
    }

    @Bean(value={"annoSyncTaskScheduler"})
    public TaskScheduler asyncTaskScheduler() {
        return new ThreadPoolTaskScheduler();
    }
}

