/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.batch;

import eu.europeana.fulltext.api.config.FTSettings;
import eu.europeana.fulltext.batch.AnnotationSyncJobConfig;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;

@Configuration
public class AnnotationSyncSchedulingConfig
implements InitializingBean {
    private final AnnotationSyncJobConfig annoSyncJobConfig;
    private final TaskScheduler annoSyncTaskScheduler;
    private static final Logger logger = LogManager.getLogger(AnnotationSyncSchedulingConfig.class);
    private final JobLauncher jobLauncher;
    private final int annoSyncInitialDelay;
    private final int annoSyncInterval;
    private final boolean annoSyncEnabled;

    public AnnotationSyncSchedulingConfig(AnnotationSyncJobConfig annoSyncJobConfig, @Qualifier(value="annoSyncTaskScheduler") TaskScheduler annoSyncTaskScheduler, JobLauncher launcher, FTSettings appSettings) {
        this.annoSyncJobConfig = annoSyncJobConfig;
        this.annoSyncTaskScheduler = annoSyncTaskScheduler;
        this.jobLauncher = launcher;
        this.annoSyncInitialDelay = appSettings.getAnnoSyncInitialDelay();
        this.annoSyncInterval = appSettings.getAnnoSyncInterval();
        this.annoSyncEnabled = appSettings.isAnnoSyncEnabled();
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.annoSyncEnabled) {
            logger.warn("Annotations syncing not enabled. Annotations will not be retrieved automatically");
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("AnnoSync scheduling initialized \u2013 initialDelay: {}; interval: {}", (Object)this.toMinutesAndSeconds((long)this.annoSyncInitialDelay), (Object)this.toMinutesAndSeconds((long)this.annoSyncInterval));
        }
        this.schedulePeriodicAnnoSync();
    }

    private void schedulePeriodicAnnoSync() {
        this.annoSyncTaskScheduler.scheduleWithFixedDelay(() -> this.runScheduledAnnoSyncJob(), Instant.now().plusSeconds(this.annoSyncInitialDelay), Duration.ofSeconds(this.annoSyncInterval));
    }

    void runScheduledAnnoSyncJob() {
        logger.info("Triggering scheduled AnnoSync job");
        try {
            String startTimeJobParam = "startTime";
            this.jobLauncher.run(this.annoSyncJobConfig.syncAnnotations(), new JobParametersBuilder().addDate(startTimeJobParam, Date.from(Instant.now())).toJobParameters());
        }
        catch (Exception e) {
            logger.warn("Error running AnnoSync job", (Throwable)e);
        }
    }

    private String toMinutesAndSeconds(long seconds) {
        return String.format("%d min, %d sec", TimeUnit.SECONDS.toMinutes(seconds), seconds - TimeUnit.MINUTES.toSeconds(TimeUnit.SECONDS.toMinutes(seconds)));
    }
}

