/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.batch;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.stereotype.Component;

@Component
public class AnnoSyncStats {
    private final AtomicInteger newAnnotations = new AtomicInteger();
    private final AtomicInteger updatedAnnotations = new AtomicInteger();
    private final AtomicInteger deprecatedAnnotations = new AtomicInteger();
    private Instant startTime;
    private Duration elapsedTime;

    public void reset() {
        this.newAnnotations.set(0);
        this.updatedAnnotations.set(0);
        this.deprecatedAnnotations.set(0);
        this.startTime = null;
        this.elapsedTime = Duration.ZERO;
    }

    public void setStartTime(Instant startTime) {
        this.startTime = startTime;
    }

    public void setElapsedTime(Duration elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public void addNew() {
        this.newAnnotations.incrementAndGet();
    }

    public void addUpdated() {
        this.updatedAnnotations.incrementAndGet();
    }

    public void addDeprecated() {
        this.deprecatedAnnotations.incrementAndGet();
    }

    public int getNew() {
        return this.newAnnotations.get();
    }

    public int getUpdated() {
        return this.updatedAnnotations.get();
    }

    public int getDeprecated() {
        return this.deprecatedAnnotations.get();
    }

    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    public Instant getStartTime() {
        return this.startTime;
    }
}

