/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.web;

import eu.europeana.fulltext.api.web.SocksProxyConfigInjector;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SocksProxyConfigInjector {
    private static final String SOCKS_ENABLED = "socks.enabled";
    private static final String SOCKS_HOST = "socks.host";
    private static final String SOCKS_PORT = "socks.port";
    private static final String SOCKS_USER = "socks.user";
    private static final String SOCKS_PASS = "socks.password";
    private static final Logger LOG = LogManager.getLogger(SocksProxyConfigInjector.class);
    private Properties props = new Properties();

    public SocksProxyConfigInjector(String propertiesFileName) throws IOException {
        this.addProperties(propertiesFileName);
    }

    public final void addProperties(String propertiesFileName) throws IOException {
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesFileName);){
            if (in == null) {
                throw new IOException("Properties file " + propertiesFileName + " doesn't exist!");
            }
            this.props.load(in);
        }
    }

    private boolean isValidConfiguration() {
        String host = this.props.getProperty(SOCKS_HOST);
        Boolean enabled = Boolean.valueOf(this.props.getProperty(SOCKS_ENABLED));
        boolean result = false;
        if (StringUtils.isEmpty((CharSequence)host)) {
            LOG.info("No socks proxy configured");
        } else if (enabled == null || !enabled.booleanValue()) {
            LOG.info("Socks proxy disabled");
        } else {
            LOG.info("Setting up socks proxy at {}", (Object)host);
            result = true;
        }
        return result;
    }

    public void inject() {
        if (this.isValidConfiguration()) {
            System.setProperty("socksProxyHost", this.props.getProperty(SOCKS_HOST));
            System.setProperty("socksProxyPort", this.props.getProperty(SOCKS_PORT));
            String user = this.props.getProperty(SOCKS_USER);
            if (StringUtils.isNotEmpty((CharSequence)user)) {
                String pass = this.props.getProperty(SOCKS_PASS);
                System.setProperty("java.net.socks.username", user);
                System.setProperty("java.net.socks.password", pass);
                Authenticator.setDefault((Authenticator)new SockProxyAuthenticator(user, pass));
            }
        }
    }
}

