/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.web;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.fulltext.AnnotationType;
import eu.europeana.fulltext.api.model.FTResource;
import eu.europeana.fulltext.api.model.info.SummaryManifest;
import eu.europeana.fulltext.api.service.CacheUtils;
import eu.europeana.fulltext.api.service.ControllerUtils;
import eu.europeana.fulltext.api.service.FTService;
import eu.europeana.fulltext.api.service.exception.InvalidVersionException;
import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.exception.SerializationException;
import eu.europeana.fulltext.util.RequestUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@Api(tags={"Full-text item"}, description="Retrieve a page with annotations, an individual annotation or a full-text")
public class FTRetrievalController {
    private static final Set<AnnotationType> ALLOWED_ANNOTATION_TYPES = EnumSet.of(AnnotationType.PAGE, new AnnotationType[]{AnnotationType.BLOCK, AnnotationType.LINE, AnnotationType.WORD, AnnotationType.MEDIA, AnnotationType.CAPTION});
    private static final Logger LOG = LogManager.getLogger(FTRetrievalController.class);
    private final FTService fts;

    public FTRetrievalController(FTService ftService) {
        this.fts = ftService;
    }

    @ApiOperation(value="Lists available Annotation Pages for a given EuropeanaID (dataset + localID)")
    @GetMapping(value={"/presentation/{datasetId}/{localId}/annopage"}, headers={"Accept=application/json"})
    public ResponseEntity<String> annoPageInfo(@PathVariable String datasetId, @PathVariable String localId, HttpServletRequest request) throws EuropeanaApiException {
        return this.getAnnoPageInfo(datasetId, localId, request);
    }

    private ResponseEntity<String> getAnnoPageInfo(String datasetId, String localId, HttpServletRequest request) throws EuropeanaApiException {
        String eTag;
        AnnoPage annoPage = this.fts.getSingleAnnoPage(datasetId, localId);
        ZonedDateTime modified = CacheUtils.dateToZonedUTC((Date)annoPage.getModified());
        ResponseEntity cached = CacheUtils.checkCached((HttpServletRequest)request, (ZonedDateTime)modified, (String)(eTag = CacheUtils.generateETag((String)(datasetId + localId), (ZonedDateTime)modified, (String)this.fts.getSettings().getAppVersion(), (boolean)true)));
        if (null != cached) {
            LOG.info("Returning cached object for {}, {}", (Object)datasetId, (Object)localId);
            return cached;
        }
        HttpHeaders headers = CacheUtils.generateHeaders((HttpServletRequest)request, (String)eTag, (String)CacheUtils.zonedDateTimeToString((ZonedDateTime)modified));
        SummaryManifest apInfo = this.fts.collectionAnnoPageInfo(datasetId, localId);
        return new ResponseEntity((Object)this.fts.serialise((Object)apInfo), (MultiValueMap)headers, HttpStatus.OK);
    }

    @ApiOperation(value="Retrieve a page with annotations")
    @GetMapping(value={"/presentation/{datasetId}/{localId}/annopage/{pageId}"}, headers={"Accept=application/json"})
    public ResponseEntity<String> annoPageJson(@PathVariable String datasetId, @PathVariable String localId, @PathVariable String pageId, @RequestParam(value="lang", required=false) String lang, @RequestParam(value="format", required=false) String versionParam, @RequestParam(value="profile", required=false) String profile, @RequestParam(value="textGranularity", required=false) String textGranularity, HttpServletRequest request) throws EuropeanaApiException {
        return this.annoPage(datasetId, localId, pageId, lang, versionParam, profile, textGranularity, request, true);
    }

    @ApiOperation(value="Retrieve a page with annotations")
    @GetMapping(value={"/presentation/{datasetId}/{localId}/annopage/{pageId}"}, headers={"Accept=application/ld+json"})
    public ResponseEntity<String> annoPageJsonLd(@PathVariable String datasetId, @PathVariable String localId, @PathVariable String pageId, @RequestParam(value="lang", required=false) String lang, @RequestParam(value="format", required=false) String versionParam, @RequestParam(value="profile", required=false) String profile, @RequestParam(value="textGranularity", required=false) String textGranularity, HttpServletRequest request) throws EuropeanaApiException {
        return this.annoPage(datasetId, localId, pageId, lang, versionParam, profile, textGranularity, request, false);
    }

    private ResponseEntity<String> annoPage(String datasetId, String localId, String pageId, String lang, String versionParam, String profileParam, String textGranularity, HttpServletRequest request, boolean isJson) throws EuropeanaApiException {
        String eTag;
        LOG.debug("Retrieve Annopage: {}/{}/{} with language {}", (Object)datasetId, (Object)localId, (Object)pageId, (Object)lang);
        String requestVersion = RequestUtils.getRequestVersion((HttpServletRequest)request, (String)versionParam);
        if (StringUtils.isEmpty((CharSequence)requestVersion)) {
            throw new InvalidVersionException("Unknown profile version indicated either in Accept or using the format field");
        }
        List textGranValues = ControllerUtils.validateTextGranularity((String)textGranularity, (Set)ALLOWED_ANNOTATION_TYPES);
        AnnoPage annoPage = this.fts.fetchAnnoPage(datasetId, localId, pageId, textGranValues, lang);
        ZonedDateTime modified = CacheUtils.dateToZonedUTC((Date)annoPage.getModified());
        ResponseEntity cached = CacheUtils.checkCached((HttpServletRequest)request, (ZonedDateTime)modified, (String)(eTag = CacheUtils.generateETag((String)(datasetId + localId + pageId), (ZonedDateTime)modified, (String)(requestVersion + this.fts.getSettings().getAppVersion()), (boolean)true)));
        if (null != cached) {
            return cached;
        }
        HttpHeaders headers = CacheUtils.generateHeaders((HttpServletRequest)request, (String)eTag, (String)CacheUtils.zonedDateTimeToString((ZonedDateTime)modified));
        this.addContentTypeToResponseHeader(headers, requestVersion, isJson);
        List profiles = RequestUtils.extractProfiles((String)profileParam);
        Object annotationPage = "3".equalsIgnoreCase(requestVersion) ? this.fts.generateAnnoPageV3(annoPage, profiles.contains("text")) : this.fts.generateAnnoPageV2(annoPage, profiles.contains("text"));
        if (isJson) {
            annotationPage.setContext(null);
        }
        return new ResponseEntity((Object)this.fts.serialise(annotationPage), (MultiValueMap)headers, HttpStatus.OK);
    }

    @ApiOperation(value="Check if a page with annotations exists")
    @RequestMapping(value={"/presentation/{datasetId}/{localId}/annopage/{pageId}"}, method={RequestMethod.HEAD}, headers={"Accept=application/json"})
    public ResponseEntity annoPageHeadExistsJson(@PathVariable String datasetId, @PathVariable String localId, @PathVariable String pageId, @RequestParam(value="lang", required=false) String lang, @RequestParam(value="format", required=false) String versionParam, HttpServletRequest request) throws EuropeanaApiException {
        return this.getAnnoPageHead(datasetId, localId, pageId, lang, versionParam, true, request);
    }

    @ApiOperation(value="Check if a page with annotations exists")
    @RequestMapping(value={"/presentation/{datasetId}/{localId}/annopage/{pageId}"}, method={RequestMethod.HEAD}, headers={"Accept=application/ld+json"})
    public ResponseEntity annoPageHeadExistsJsonld(@PathVariable String datasetId, @PathVariable String localId, @PathVariable String pageId, @RequestParam(value="lang", required=false) String lang, @RequestParam(value="format", required=false) String versionParam, HttpServletRequest request) throws EuropeanaApiException {
        return this.getAnnoPageHead(datasetId, localId, pageId, lang, versionParam, false, request);
    }

    private ResponseEntity getAnnoPageHead(String datasetId, String localId, String pageId, String lang, String versionParam, boolean isJson, HttpServletRequest request) throws InvalidVersionException {
        String requestVersion = RequestUtils.getRequestVersion((HttpServletRequest)request, (String)versionParam);
        if (StringUtils.isEmpty((CharSequence)requestVersion)) {
            throw new InvalidVersionException("Unknown profile version indicated either in Accept or using the format field");
        }
        HttpHeaders headers = new HttpHeaders();
        this.addContentTypeToResponseHeader(headers, requestVersion, isJson);
        if (this.fts.doesAnnoPageExist(datasetId, localId, pageId, lang, false)) {
            return new ResponseEntity((MultiValueMap)headers, HttpStatus.OK);
        }
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.NOT_FOUND);
    }

    @ApiOperation(value="Retrieve a single annotation")
    @GetMapping(value={"/presentation/{datasetId}/{localId}/anno/{annoID}"}, headers={"Accept=application/json"})
    public ResponseEntity<String> annotationJson(@PathVariable String datasetId, @PathVariable String localId, @PathVariable String annoID, @RequestParam(value="format", required=false) String versionParam, HttpServletRequest request) throws EuropeanaApiException {
        return this.annotation(datasetId, localId, annoID, versionParam, request, true);
    }

    @ApiOperation(value="Retrieve a single annotation")
    @GetMapping(value={"/presentation/{datasetId}/{localId}/anno/{annoID}"}, headers={"Accept=application/ld+json"})
    public ResponseEntity<String> annotationJsonLd(@PathVariable String datasetId, @PathVariable String localId, @PathVariable String annoID, @RequestParam(value="format", required=false) String versionParam, HttpServletRequest request) throws EuropeanaApiException {
        return this.annotation(datasetId, localId, annoID, versionParam, request, false);
    }

    private ResponseEntity<String> annotation(String datasetId, String localId, String annoID, String versionParam, HttpServletRequest request, boolean isJson) throws EuropeanaApiException {
        String eTag;
        LOG.debug("Retrieve Annotation: {}/{}/{}", (Object)datasetId, (Object)localId, (Object)annoID);
        String requestVersion = RequestUtils.getRequestVersion((HttpServletRequest)request, (String)versionParam);
        if (StringUtils.isEmpty((CharSequence)requestVersion)) {
            throw new InvalidVersionException("Unknown profile version indicated either in Accept or using the format field");
        }
        AnnoPage annoPage = this.fts.fetchAPAnnotation(datasetId, localId, annoID);
        ZonedDateTime modified = CacheUtils.dateToZonedUTC((Date)annoPage.getModified());
        ResponseEntity cached = CacheUtils.checkCached((HttpServletRequest)request, (ZonedDateTime)modified, (String)(eTag = CacheUtils.generateETag((String)(datasetId + localId + annoID), (ZonedDateTime)modified, (String)(requestVersion + this.fts.getSettings().getAppVersion()), (boolean)true)));
        if (cached != null) {
            return cached;
        }
        HttpHeaders headers = CacheUtils.generateHeaders((HttpServletRequest)request, (String)eTag, (String)CacheUtils.zonedDateTimeToString((ZonedDateTime)modified));
        this.addContentTypeToResponseHeader(headers, requestVersion, isJson);
        Object annotation = "3".equalsIgnoreCase(requestVersion) ? this.fts.generateAnnotationV3(annoPage, annoID) : this.fts.generateAnnotationV2(annoPage, annoID);
        if (isJson) {
            annotation.setContext(null);
        }
        return new ResponseEntity((Object)this.fts.serialise(annotation), (MultiValueMap)headers, HttpStatus.OK);
    }

    @ApiOperation(value="Retrieve a full-text")
    @GetMapping(value={"/presentation/{datasetId}/{localId}/{pageId}"}, headers={"Accept=application/ld+json"}, produces={"application/ld+json;charset=UTF-8"})
    public ResponseEntity<String> resourceJsonLd(@PathVariable String datasetId, @PathVariable String localId, @PathVariable String pageId, @RequestParam(value="lang", required=false) String lang, HttpServletRequest request) throws EuropeanaApiException {
        return this.resource(datasetId, localId, pageId, lang, request, false);
    }

    @ApiOperation(value="Retrieve a full-text")
    @GetMapping(value={"/presentation/{datasetId}/{localId}/{pageId}"}, headers={"Accept=application/json"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> resourceJson(@PathVariable String datasetId, @PathVariable String localId, @PathVariable String pageId, @RequestParam(value="lang", required=false) String lang, HttpServletRequest request) throws EuropeanaApiException {
        return this.resource(datasetId, localId, pageId, lang, request, true);
    }

    private ResponseEntity<String> resource(String datasetId, String localId, String pageId, String lang, HttpServletRequest request, boolean isJson) throws EuropeanaApiException {
        LOG.debug("Retrieve Resource: {}/{}/{}", (Object)datasetId, (Object)localId, (Object)pageId);
        FTResource resource = this.fts.fetchFTResource(datasetId, localId, pageId, lang);
        ZonedDateTime modified = CacheUtils.januarificator();
        String eTag = CacheUtils.generateSimpleETag((String)(datasetId + localId + pageId + resource.getLanguage() + resource.getValue() + this.fts.getSettings().getAppVersion()), (boolean)true);
        ResponseEntity cached = CacheUtils.checkCached((HttpServletRequest)request, (ZonedDateTime)modified, (String)eTag);
        if (cached != null) {
            return cached;
        }
        HttpHeaders headers = CacheUtils.generateHeaders((HttpServletRequest)request, (String)eTag, (String)CacheUtils.zonedDateTimeToString((ZonedDateTime)modified));
        headers.add("Content-Type", (isJson ? "application/json" : "application/ld+json") + ";charset=UTF-8");
        if (isJson) {
            resource.setContext(null);
        }
        return new ResponseEntity((Object)this.fts.serialise((Object)resource), (MultiValueMap)headers, HttpStatus.OK);
    }

    private void addContentTypeToResponseHeader(HttpHeaders headers, String version, boolean isJson) {
        if ("3".equalsIgnoreCase(version)) {
            if (isJson) {
                headers.add("Content-Type", "application/json;profile=\"http://iiif.io/api/presentation/3/context.json\";charset=UTF-8");
            } else {
                headers.add("Content-Type", "application/ld+json;profile=\"http://iiif.io/api/presentation/3/context.json\";charset=UTF-8");
            }
        } else if (isJson) {
            headers.add("Content-Type", "application/json;profile=\"http://iiif.io/api/presentation/2/context.json\";charset=UTF-8");
        } else {
            headers.add("Content-Type", "application/ld+json;profile=\"http://iiif.io/api/presentation/2/context.json\";charset=UTF-8");
        }
    }

    @ApiIgnore
    @GetMapping(value={"/presentation/showversion"})
    public ResponseEntity<String> showVersion() throws SerializationException {
        String response = "The version of this API is: " + this.fts.getSettings().getAppVersion();
        return new ResponseEntity((Object)this.fts.serialise((Object)response), HttpStatus.I_AM_A_TEAPOT);
    }
}

