/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.service;

import com.dotsub.converter.exception.FileFormatException;
import com.dotsub.converter.importer.SubtitleImportHandler;
import com.dotsub.converter.importer.impl.DfxpImportHandler;
import com.dotsub.converter.importer.impl.SrtImportHandler;
import com.dotsub.converter.importer.impl.WebVttImportHandler;
import com.dotsub.converter.model.SubtitleItem;
import eu.europeana.fulltext.AnnotationType;
import eu.europeana.fulltext.AppConstants;
import eu.europeana.fulltext.api.service.FulltextConverter;
import eu.europeana.fulltext.edm.EdmAnnotation;
import eu.europeana.fulltext.edm.EdmFullTextPackage;
import eu.europeana.fulltext.edm.EdmFullTextResource;
import eu.europeana.fulltext.edm.EdmReference;
import eu.europeana.fulltext.edm.EdmTextBoundary;
import eu.europeana.fulltext.edm.EdmTimeBoundary;
import eu.europeana.fulltext.exception.InvalidFormatException;
import eu.europeana.fulltext.exception.SubtitleParsingException;
import eu.europeana.fulltext.subtitles.AnnotationPreview;
import eu.europeana.fulltext.subtitles.FulltextType;
import eu.europeana.fulltext.util.GeneralUtils;
import eu.europeana.fulltext.util.SubtitleContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubtitleFulltextConverter
implements FulltextConverter {
    private static final Logger logger = LogManager.getLogger(SubtitleFulltextConverter.class);
    private static final Pattern PATTERN = Pattern.compile("[<][/]?[^<]+[/]?[>]");
    private static final Map<FulltextType, SubtitleImportHandler> subtitleImportHandlerMap = Map.of(FulltextType.WEB_VTT, new WebVttImportHandler(), FulltextType.SUB_RIP, new SrtImportHandler(), FulltextType.TTML, new DfxpImportHandler());

    public EdmFullTextPackage convert(AnnotationPreview annotationPreview) throws InvalidFormatException, SubtitleParsingException {
        List subtitleItems = this.parseSubtitle((InputStream)new ByteArrayInputStream(annotationPreview.getAnnotationBody().getBytes(StandardCharsets.UTF_8)), annotationPreview.getFulltextType());
        String uri = "http://data.europeana.eu/item" + annotationPreview.getRecordId();
        String annotationPageURI = GeneralUtils.getAnnotationPageURI((String)annotationPreview.getRecordId());
        String fullTextResourceURI = GeneralUtils.getFullTextResourceURI((String)annotationPreview.getRecordId(), (String)GeneralUtils.generateResourceId((String)annotationPreview.getRecordId(), (String)annotationPreview.getLanguage(), (String)annotationPreview.getMedia()));
        EdmFullTextPackage page = new EdmFullTextPackage(annotationPageURI, null);
        EdmFullTextResource resource = new EdmFullTextResource(fullTextResourceURI, null, annotationPreview.getLanguage(), annotationPreview.getRights(), uri);
        EdmTextBoundary tb = new EdmTextBoundary(fullTextResourceURI);
        page.add((Object)new EdmAnnotation((EdmReference)tb, null, AnnotationType.MEDIA, null, null));
        SubtitleContext subtitleContext = new SubtitleContext();
        subtitleContext.start(fullTextResourceURI);
        int i = 0;
        for (SubtitleItem item : subtitleItems) {
            if (i++ != 0) {
                subtitleContext.separator();
            }
            int start = item.getStartTime();
            int end = start + item.getDuration();
            EdmTimeBoundary mr = new EdmTimeBoundary(annotationPreview.getMedia(), start, end);
            EdmTextBoundary tr = subtitleContext.newItem(this.processSubtitle(item.getContent()));
            page.add((Object)new EdmAnnotation((EdmReference)tr, mr, AnnotationType.CAPTION, null, null));
        }
        resource.setValue(subtitleContext.end());
        page.setResource(resource);
        if (logger.isTraceEnabled()) {
            logger.trace("Successfully converted SRT to EDM for record {}. Processed Annotations - {}", (Object)annotationPreview.getRecordId(), (Object)page.size());
        }
        return page;
    }

    public List<SubtitleItem> parseSubtitle(InputStream text, FulltextType fulltextType) throws InvalidFormatException, SubtitleParsingException {
        try {
            List result = ((SubtitleImportHandler)subtitleImportHandlerMap.get(fulltextType)).importFile(text, AppConstants.defaultSubtitleConfig);
            if (result.isEmpty()) {
                throw new SubtitleParsingException("Please provide proper data!! Text passed is not parseable.");
            }
            return result;
        }
        catch (FileFormatException e) {
            throw new InvalidFormatException("Please provide proper format!! File does not match the expected format - " + fulltextType.getMimeType());
        }
        catch (IOException e) {
            throw new SubtitleParsingException(e.getMessage());
        }
    }

    private String processSubtitle(String text) {
        return PATTERN.matcher(text).replaceAll("");
    }
}

