/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.service;

import eu.europeana.fulltext.api.config.FTSettings;
import eu.europeana.fulltext.batch.AnnoSyncStats;
import eu.europeana.fulltext.batch.BatchUtils;
import java.time.Duration;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

@Component
public class EmailService {
    private final String from;
    private final String to;
    private final String cc;
    private final String deploymentName;
    private final SpringTemplateEngine thymeleafTemplateEngine;
    private static final Logger logger = LogManager.getLogger(EmailService.class);
    private final JavaMailSender emailSender;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXX").withZone(ZoneId.of("UTC"));

    public EmailService(JavaMailSender emailSender, FTSettings settings, SpringTemplateEngine thymeleafTemplateEngine) {
        this.emailSender = emailSender;
        this.from = settings.getMailFrom();
        this.to = settings.getMailTo();
        this.cc = settings.getMailCc();
        this.deploymentName = settings.getDeploymentName();
        this.thymeleafTemplateEngine = thymeleafTemplateEngine;
    }

    private void sendHtmlMessage(String subject, String body) {
        try {
            MimeMessage message = this.emailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            helper.setTo(this.to);
            helper.setFrom(this.from);
            if (StringUtils.hasLength((String)this.cc)) {
                helper.setCc(this.cc);
            }
            helper.setSubject(subject);
            helper.setText(body, true);
            this.emailSender.send(message);
            logger.info("Email with subject {} sent. to={}; cc={}", (Object)subject, (Object)this.to, (Object)this.cc);
        }
        catch (MessagingException e) {
            logger.warn("Error sending email message: body={}", (Object)body, (Object)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Sent email to {}; subject={}; body={}", (Object)this.to, (Object)subject, (Object)body);
        }
    }

    public void sendAnnoSyncSuccessEmail(String subject, AnnoSyncStats stats, String searchQuery) {
        Context thymeleafContext = new Context();
        Map<String, String> templateModel = Map.of("startTimeString", stats.getStartTime() == null ? "" : this.formatter.format(stats.getStartTime()), "durationString", BatchUtils.getDurationText((Duration)stats.getElapsedTime()), "numNewAnnopages", stats.getNew(), "numUpdatedAnnopages", stats.getUpdated(), "numDeprecatedAnnopages", stats.getDeprecated(), "annotationSearchQuery", searchQuery, "deploymentName", this.deploymentName);
        thymeleafContext.setVariables(templateModel);
        String htmlBody = this.thymeleafTemplateEngine.process("annosync-success.html", (IContext)thymeleafContext);
        this.sendHtmlMessage(subject, htmlBody);
    }
}

