/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.service;

import eu.europeana.fulltext.api.config.FTSettings;
import eu.europeana.fulltext.exception.AnnotationApiGoneException;
import eu.europeana.fulltext.exception.AnnotationApiNotFoundException;
import eu.europeana.fulltext.exception.AnnotationApiRequestException;
import eu.europeana.fulltext.subtitles.external.AnnotationItem;
import eu.europeana.fulltext.subtitles.external.AnnotationSearchResponse;
import eu.europeana.fulltext.util.GeneralUtils;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilder;
import reactor.core.Exceptions;

@Service
public class AnnotationApiRestService {
    private final WebClient webClient;
    private static final Logger logger = LogManager.getLogger(AnnotationApiRestService.class);
    private final DateTimeFormatter deletedDateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final String wskey;

    public AnnotationApiRestService(FTSettings settings, WebClient webClient) {
        this.wskey = settings.getAnnotationsApiKey();
        this.webClient = webClient;
    }

    public List<AnnotationItem> getAnnotations(int page, int pageSize, Instant from, Instant to) {
        String searchQuery = GeneralUtils.generateAnnotationSearchQuery((Instant)from, (Instant)to);
        AnnotationSearchResponse response = (AnnotationSearchResponse)this.webClient.get().uri(uriBuilder -> uriBuilder.path("/annotation/search").queryParam("query", new Object[]{searchQuery}).queryParam("wskey", new Object[]{this.wskey}).queryParam("sort", new Object[]{"created"}).queryParam("sortOrder", new Object[]{"asc"}).queryParam("page", new Object[]{page}).queryParam("pageSize", new Object[]{pageSize}).build(new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().onStatus(arg_0 -> HttpStatus.NOT_FOUND.equals(arg_0), errorResponse -> errorResponse.bodyToMono(String.class).map(AnnotationApiRequestException::new)).bodyToMono(AnnotationSearchResponse.class).block();
        if (response == null) {
            logger.warn("AnnotationSearchResponse not deserialized");
            return Collections.emptyList();
        }
        List items = response.getItems();
        if (logger.isDebugEnabled()) {
            int fetchedItems = items == null ? 0 : items.size();
            logger.debug("Retrieved {} annotations; totalItems={} ", (Object)fetchedItems, (Object)response.getTotal());
        }
        return items;
    }

    public Optional<AnnotationItem> retrieveAnnotation(String annotationId) throws AnnotationApiNotFoundException {
        String uri = annotationId + "?wskey=" + this.wskey;
        try {
            return Optional.ofNullable((AnnotationItem)this.webClient.get().uri(URI.create(uri)).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().onStatus(arg_0 -> HttpStatus.GONE.equals(arg_0), response -> response.bodyToMono(String.class).map(AnnotationApiGoneException::new)).onStatus(arg_0 -> HttpStatus.NOT_FOUND.equals(arg_0), response -> response.bodyToMono(String.class).map(AnnotationApiNotFoundException::new)).bodyToMono(AnnotationItem.class).block());
        }
        catch (Exception e) {
            Throwable t = Exceptions.unwrap((Throwable)e);
            if (t instanceof AnnotationApiGoneException) {
                return Optional.empty();
            }
            if (t instanceof AnnotationApiNotFoundException) {
                throw new AnnotationApiNotFoundException("Annotation does not exist");
            }
            throw e;
        }
    }

    public List<String> getDeletedAnnotations(int page, int pageSize, Instant from, Instant to) {
        List deletedAnnotations = (List)this.webClient.get().uri(this.buildUriForDeletedAnnotations(page, pageSize, from, to)).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).block();
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved deleted annotations ids={}", (Object)deletedAnnotations);
        }
        return deletedAnnotations;
    }

    private Function<UriBuilder, URI> buildUriForDeletedAnnotations(int page, int pageSize, Instant from, Instant to) {
        return uriBuilder -> {
            UriBuilder builder = uriBuilder.path("/annotations/deleted").queryParam("wskey", new Object[]{this.wskey}).queryParam("page", new Object[]{page}).queryParam("limit", new Object[]{pageSize});
            if (from != null) {
                builder.queryParam("from", new Object[]{from.atZone(ZoneOffset.UTC).format(this.deletedDateFormat)});
            }
            if (to != null) {
                builder.queryParam("to", new Object[]{to.atZone(ZoneOffset.UTC).format(this.deletedDateFormat)});
            }
            return builder.build(new Object[0]);
        };
    }
}

