/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.config;

import eu.europeana.fulltext.AnnotationType;
import eu.europeana.fulltext.api.service.ControllerUtils;
import eu.europeana.fulltext.search.exception.InvalidParameterException;
import eu.europeana.fulltext.search.web.FTSearchController;
import eu.europeana.fulltext.util.GeneralUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.env.Environment;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:fulltext.properties"}), @PropertySource(value={"classpath:fulltext.user.properties"}, ignoreResourceNotFound=true)})
public class FTSettings
implements InitializingBean {
    private static final Logger LOG = LogManager.getLogger(FTSettings.class);
    private Boolean suppressParseException = false;
    @Value(value="${annopage.baseurl}")
    private String annoPageBaseUrl;
    @Value(value="${annotation.baseurl}")
    private String annotationBaseUrl;
    @Value(value="${resource.baseurl}")
    private String resourceBaseUrl;
    @Value(value="${search.textGranularity.default:Word}")
    private String searchTextGranularity;
    private List<AnnotationType> defaultSearchTextGranularity;
    @Value(value="${spring.profiles.active:}")
    private String activeProfileString;
    @Value(value="${auth.enabled}")
    private boolean authEnabled;
    @Value(value="${europeana.apikey.jwttoken.signaturekey}")
    private String apiKeyPublicKey;
    @Value(value="${authorization.api.name}")
    private String authorizationApiName;
    @Value(value="${europeana.apikey.serviceurl}")
    private String apiKeyUrl;
    @Value(value="${mongo.connectionUrl}")
    private String mongoConnectionUrl;
    @Value(value="${mongo.fulltext.database}")
    private String fulltextDatabase;
    @Value(value="${mongo.fulltext.ensureIndices: false}")
    private boolean ensureFulltextIndices;
    @Value(value="${annotations.serviceurl}")
    private String annotationsApiUrl;
    @Value(value="${annotations.id.hosts}")
    private String annotationIdHostsPattern;
    @Value(value="${annotations.wskey}")
    private String annotationsApiKey;
    @Value(value="${batch.annotations.pageSize: 50}")
    private int annotationItemsPageSize;
    @Value(value="${batch.executor.corePool: 5}")
    private int batchCorePoolSize;
    @Value(value="${batch.step.skipLimit: 10}")
    private int batchSkipLimit;
    @Value(value="${batch.executor.maxPool: 10}")
    private int batchMaxPoolSize;
    @Value(value="${batch.step.executor.queueSize: 5}")
    private int batchQueueSize;
    @Value(value="${batch.step.throttleLimit: 5}")
    private int annoSyncThrottleLimit;
    @Value(value="${annosync.initialDelaySeconds}")
    private int annoSyncInitialDelay;
    @Value(value="${annosync.intervalSeconds}")
    private int annoSyncInterval;
    @Value(value="${spring.data.solr.repositories.enabled}")
    private boolean solrEnabled;
    @Value(value="${annosync.enabled}")
    private boolean annoSyncEnabled;
    @Value(value="${annosync.mail.enabled}")
    private boolean annoSyncMailEnabled;
    @Value(value="${annosync.mail.from:}")
    private String mailFrom;
    @Value(value="${annosync.mail.to:}")
    private String mailTo;
    @Value(value="${annosync.mail.cc:}")
    private String mailCc;
    @Value(value="${fulltext.deployment:}")
    private String deploymentName;
    @Value(value="${webclient.maxBufferMb:16}")
    private int maxBufferMb;
    @Value(value="${annotations.retry:3}")
    private int retryLimit;
    @Autowired
    private Environment environment;

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public String getAuthorizationApiName() {
        return this.authorizationApiName;
    }

    public String getApiKeyPublicKey() {
        return this.apiKeyPublicKey;
    }

    public String getApiKeyUrl() {
        return this.apiKeyUrl;
    }

    public String getMongoConnectionUrl() {
        return this.mongoConnectionUrl;
    }

    public String getFulltextDatabase() {
        return this.fulltextDatabase;
    }

    public boolean ensureFulltextIndices() {
        return this.ensureFulltextIndices;
    }

    public String getAnnotationsApiKey() {
        return this.annotationsApiKey;
    }

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public String getAnnotationsApiUrl() {
        return this.annotationsApiUrl;
    }

    public int getAnnotationItemsPageSize() {
        return this.annotationItemsPageSize;
    }

    public int getBatchCorePoolSize() {
        return this.batchCorePoolSize;
    }

    public int getBatchMaxPoolSize() {
        return this.batchMaxPoolSize;
    }

    public int getBatchQueueSize() {
        return this.batchQueueSize;
    }

    public int getAnnoSyncInitialDelay() {
        return this.annoSyncInitialDelay;
    }

    public int getAnnoSyncInterval() {
        return this.annoSyncInterval;
    }

    public int getAnnoSyncThrottleLimit() {
        return this.annoSyncThrottleLimit;
    }

    public String getAnnotationIdHostsPattern() {
        return this.annotationIdHostsPattern;
    }

    private void setupTextGranularity() throws InvalidParameterException {
        if (StringUtils.isBlank((CharSequence)this.searchTextGranularity)) {
            LOG.info("No default text granularity for search found in configuration files");
            this.defaultSearchTextGranularity = Arrays.asList(AnnotationType.LINE);
        } else {
            this.defaultSearchTextGranularity = ControllerUtils.validateTextGranularity((String)this.searchTextGranularity, (Set)FTSearchController.ALLOWED_ANNOTATION_TYPES);
        }
        LOG.info("Default text granularity for search = {}", (Object)this.searchTextGranularity);
    }

    public Boolean getSuppressParseException() {
        return this.suppressParseException;
    }

    public String getAppVersion() {
        Properties buildProperties = new Properties();
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/build.properties");
        try {
            buildProperties.load(resourceAsStream);
            return this.environment.getProperty("info.app.version");
        }
        catch (IOException e) {
            LogManager.getLogger(FTSettings.class).warn("Error loading build.properties", (Throwable)e);
            return "default";
        }
    }

    public String getAnnoPageBaseUrl() {
        return this.annoPageBaseUrl;
    }

    public String getAnnotationBaseUrl() {
        return this.annotationBaseUrl;
    }

    public String getResourceBaseUrl() {
        return this.resourceBaseUrl;
    }

    public List<AnnotationType> getDefaultSearchTextGranularity() {
        return Collections.unmodifiableList(this.defaultSearchTextGranularity);
    }

    public void afterPropertiesSet() throws Exception {
        if (GeneralUtils.testProfileNotActive((String)this.activeProfileString)) {
            this.validateRequiredSettings();
        }
        this.setupTextGranularity();
    }

    private void validateRequiredSettings() {
        ArrayList<String> missingProps = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)this.annotationsApiKey)) {
            missingProps.add("annotations.wskey");
        }
        if (StringUtils.isEmpty((CharSequence)this.apiKeyPublicKey)) {
            missingProps.add("europeana.apikey.jwttoken.signaturekey");
        }
        if (StringUtils.isEmpty((CharSequence)this.apiKeyUrl)) {
            missingProps.add("europeana.apikey.serviceurl");
        }
        if (StringUtils.isEmpty((CharSequence)this.annotationsApiUrl)) {
            missingProps.add("annotations.serviceurl");
        }
        if (!missingProps.isEmpty()) {
            throw new IllegalStateException(String.format("The following config properties are not set: %s", String.join((CharSequence)"\n", missingProps)));
        }
    }

    public boolean isSolrEnabled() {
        return this.solrEnabled;
    }

    public boolean isAnnoSyncEnabled() {
        return this.annoSyncEnabled;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public String getMailTo() {
        return this.mailTo;
    }

    public String getMailCc() {
        return this.mailCc;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public boolean annoSyncMailEnabled() {
        return this.annoSyncMailEnabled;
    }

    public int getMaxBufferMb() {
        return this.maxBufferMb;
    }

    public int getSkipLimit() {
        return this.batchSkipLimit;
    }
}

