/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.api.config;

import eu.europeana.api.commons.oauth2.service.impl.EuropeanaClientDetailsService;
import eu.europeana.fulltext.api.config.FTSettings;
import io.netty.handler.logging.LogLevel;
import java.nio.charset.StandardCharsets;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import reactor.netty.http.client.HttpClient;
import reactor.netty.transport.logging.AdvancedByteBufFormat;

@Configuration
public class BeanConfig {
    private final FTSettings settings;

    public BeanConfig(FTSettings settings) {
        this.settings = settings;
    }

    @Bean
    public EuropeanaClientDetailsService clientDetailsService() {
        EuropeanaClientDetailsService clientDetailsService = new EuropeanaClientDetailsService();
        clientDetailsService.setApiKeyServiceUrl(this.settings.getApiKeyUrl());
        return clientDetailsService;
    }

    @Bean
    public SpringTemplateEngine springTemplateEngine() {
        SpringTemplateEngine springTemplateEngine = new SpringTemplateEngine();
        springTemplateEngine.addTemplateResolver((ITemplateResolver)this.emailTemplateResolver());
        return springTemplateEngine;
    }

    @Bean
    public WebClient webClient() {
        ExchangeStrategies strategies = ExchangeStrategies.builder().codecs(codecs -> codecs.defaultCodecs().maxInMemorySize(this.settings.getMaxBufferMb() * 1024 * 1024)).build();
        return WebClient.builder().exchangeStrategies(strategies).baseUrl(this.settings.getAnnotationsApiUrl()).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector((HttpClient)HttpClient.create().followRedirect(true).wiretap(HttpClient.class.getName(), LogLevel.TRACE, AdvancedByteBufFormat.TEXTUAL))).build();
    }

    private ClassLoaderTemplateResolver emailTemplateResolver() {
        ClassLoaderTemplateResolver emailTemplateResolver = new ClassLoaderTemplateResolver();
        emailTemplateResolver.setPrefix("/templates/");
        emailTemplateResolver.setSuffix(".html");
        emailTemplateResolver.setTemplateMode(TemplateMode.HTML);
        emailTemplateResolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
        emailTemplateResolver.setCacheable(false);
        return emailTemplateResolver;
    }
}

