/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.xml.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import eu.europeana.entity.definitions.model.Entity;
import eu.europeana.entity.definitions.model.Organization;
import eu.europeana.entity.web.xml.model.EdmWebResource;
import eu.europeana.entity.web.xml.model.RdfResource;
import eu.europeana.entity.web.xml.model.RdfXmlUtils;
import eu.europeana.entity.web.xml.model.XmlAddressImpl;
import eu.europeana.entity.web.xml.model.XmlBaseEntityImpl;
import eu.europeana.entity.web.xml.model.XmlMultilingualString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JacksonXmlRootElement(localName="edm:Organization")
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"foaf:depiction", "skos:prefLabel", "edm:acronym", "skos:altLabel", "dc:description", "foaf:logo", "edm:europeanaRole", "edm:country", "foaf:homepage", "foaf:phone", "foaf:mbox", "vcard:hasAddress", "vcard:Address", "dc:identifier", "owl:sameAs", "edm:aggregatedVia", "ore:isAggregatedBy"})
public class XmlOrganizationImpl
extends XmlBaseEntityImpl {
    public XmlOrganizationImpl(Organization organization) {
        super((Entity)organization);
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="edm:acronym")
    public List<XmlMultilingualString> getAcronym() {
        return RdfXmlUtils.convertToXmlMultilingualString((Map)this.getOrganization().getAcronym());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="dc:description")
    public List<XmlMultilingualString> getDescription() {
        return RdfXmlUtils.convertMapToXmlMultilingualString((Map)this.getOrganization().getDescription());
    }

    @JacksonXmlProperty(localName="foaf:logo")
    public EdmWebResource getLogo() {
        if (this.getOrganization().getLogo() == null) {
            return null;
        }
        return new EdmWebResource(this.getOrganization().getLogo());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="edm:europeanaRole")
    public List<RdfResource> getEuropeanaRole() {
        if (this.getOrganization().getEuropeanaRole() == null) {
            return null;
        }
        ArrayList<RdfResource> roles = new ArrayList<RdfResource>(this.getOrganization().getEuropeanaRole().size());
        for (String role : this.getOrganization().getEuropeanaRole()) {
            roles.add(new RdfResource(role));
        }
        return roles;
    }

    @JacksonXmlProperty(localName="edm:country")
    public List<String> getCountry() {
        if (this.getOrganization().getCountry() == null || this.getOrganization().getCountry().isEmpty()) {
            return null;
        }
        return this.getOrganization().getCountry();
    }

    @JacksonXmlProperty(localName="foaf:homepage")
    public RdfResource getHomepage() {
        if (this.getOrganization().getHomepage() == null) {
            return null;
        }
        return new RdfResource(this.getOrganization().getHomepage());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="foaf:phone")
    public List<String> getPhone() {
        if (this.getOrganization().getPhone() == null || this.getOrganization().getPhone().size() == 0) {
            return null;
        }
        return this.getOrganization().getPhone();
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="foaf:mbox")
    public List<String> getMbox() {
        if (this.getOrganization().getMbox() == null || this.getOrganization().getMbox().size() == 0) {
            return null;
        }
        return this.getOrganization().getMbox();
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="dc:identifier")
    public String[] getIdentifier() {
        return this.getOrganization().getIdentifier();
    }

    @JsonIgnore
    private Organization getOrganization() {
        return (Organization)this.entity;
    }

    @JacksonXmlElementWrapper(localName="vcard:hasAddress")
    @JacksonXmlProperty(localName="vcard:Address")
    public XmlAddressImpl[] getHasAddress() {
        XmlAddressImpl[] tmp = new XmlAddressImpl[]{new XmlAddressImpl(this.getOrganization())};
        return tmp;
    }
}

